/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.1.9")
@CheckName(value="XVM.2.1.9")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.TLM_PORT, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Hierarchical references cannot exceed one level")
@CheckDescription(value="Hierarchical references are allowed only for grabbing the handle of a child component's TLM interface.\nThese references shall never exceed one level of hierarchy.\nException 1: In the connect phase method, environment components may use any levels of hierarchy to connect child sequencers TLM ports to other children.\nException 2: In a sequence, direct children of p_sequencer or m_sequencer can be used. These references shall never exceed one level of hierarchy children. This is required for sequencer layering.\nHierarchical references through xvm_root are not allowed.\n\nCheck supports pre-waiving.")
public class Check_2_1_9
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of patterns to match the full name of methods in which to skip checking.", name="skipMethodPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pSkipMethods;
    @CheckParameter(defaultValue="", description="Comma separated list of xvm_root API that may be accessed.", name="skipRootAPICalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pskipXVMRootAPICalls;
    @CheckParameter(defaultValue="", description="Comma separated list of classes full names where xvm_root API, specified using 'skipRootAPICalls', may be accessed.", name="skipRootAPICallsInClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pClassesOfSkippedRootAPICalls;
    @CheckParameter(defaultValue="", description="Comma separated list of methods full names that may be accessed.", name="allowMethodCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowMethodCalls;
    @CheckParameter(defaultValue="0", description="Defines the maximum level of hierarchical accesses for sequencers. All hierarchical accesses must be of a type inheriting from uvm_sequencer_base.", name="sequencerHierarchicalLevels", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pSequencerHierarchicalLevels;
    private static final String XVM_ROOT_REFERENCES_ERROR_MESSAGE_FORMAT = "Hierarchical references through {0}: ''{1}''!";
    private static final String EXCEEDING_REFERENCES_ERROR_MESSAGE_FORMAT = "Hierarchical reference{0}!";
    private String connectPhaseMethodName;
    private String connectMethodFullName;
    private String portBaseClassFullName;
    private String rootClassFullName;
    private String componentClassFullName;
    private String sequencerClassFullName;
    private String sequenceClassName;
    HashSet<RfNamedElement> allowedFunctions;

    public Check_2_1_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.allowedFunctions = new HashSet();
        NullProtectedList<RfNamedElement> allFunction = this.fOVMProject.getAllFunctions();
        for (RfNamedElement function : allFunction) {
            String fullName = function.getFullName();
            if (!this.pAllowMethodCalls.contains(fullName)) continue;
            this.allowedFunctions.add(function);
        }
        HashSet<RfFunction> functionChildren = new HashSet<RfFunction>();
        for (RfNamedElement function : this.allowedFunctions) {
            RfClass enclosingClass;
            if (function instanceof RfFunction && !((RfFunction)function).isVirtual() || (enclosingClass = function.getEnclosingScope(RfClass.class)) == null) continue;
            functionChildren.addAll(this.getFunctionChildren(function.getName(), new HashSet<RfClass>(), enclosingClass));
        }
        this.allowedFunctions.addAll(functionChildren);
        String packageName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg");
        this.connectPhaseMethodName = this.fOVMProject.getConnectPhaseMethodName();
        this.portBaseClassFullName = String.valueOf(packageName) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        this.rootClassFullName = String.valueOf(packageName) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_root");
        this.componentClassFullName = String.valueOf(packageName) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component");
        this.sequencerClassFullName = String.valueOf(packageName) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequencer_base");
        this.sequenceClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence");
        this.connectMethodFullName = String.valueOf(this.portBaseClassFullName) + ".connect";
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        LocalHidVisitor hidVisitor = new LocalHidVisitor();
        LocalNamedElementVisitor neVisitor = new LocalNamedElementVisitor(rfProject, hidVisitor, this);
        rfProject.accept(neVisitor);
    }

    private HierarchicalReferenceType getReferenceType(RfClass associatedType) {
        RfClass parent = associatedType;
        while (parent != null) {
            String name = parent.getFullName();
            if (name.equals(this.rootClassFullName)) {
                return HierarchicalReferenceType.ROOT;
            }
            if (name.equals(this.componentClassFullName)) {
                return HierarchicalReferenceType.COMPONENT;
            }
            if (name.equals(this.portBaseClassFullName)) {
                return HierarchicalReferenceType.PORT;
            }
            if (name.equals(this.sequencerClassFullName)) {
                return HierarchicalReferenceType.SEQUENCER;
            }
            parent = parent.getParent();
        }
        return HierarchicalReferenceType.OTHER;
    }

    private Set<RfFunction> getFunctionChildren(String functionName, Set<RfClass> visited, RfClass enclosingClass) {
        HashSet<RfFunction> result = new HashSet<RfFunction>();
        if (visited.contains(enclosingClass)) {
            return result;
        }
        visited.add(enclosingClass);
        Set<RfClass> childernClasses = enclosingClass.getChildren();
        if (childernClasses == null) {
            return result;
        }
        for (RfClass classs : childernClasses) {
            RfFunction localFunction = classs.getFunctionWithPrefix(functionName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (localFunction != null) {
                result.add(localFunction);
            }
            result.addAll(this.getFunctionChildren(functionName, visited, classs));
        }
        return result;
    }

    private static enum HierarchicalReferenceType {
        ROOT,
        COMPONENT,
        PORT,
        OTHER,
        SEQUENCER;

    }

    class LocalHidVisitor
    extends RfHidVisitor {
        private Map<ParserPath, Set<HidOccurrence>> allowedHidsOccurence = new HashMap<ParserPath, Set<HidOccurrence>>();

        LocalHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            RfClass enclosingClass;
            RfNamedElement associatedType;
            RfFunction enclosingFunction;
            boolean inConnectPhase = false;
            int nofLevels = Check_2_1_9.this.pSequencerHierarchicalLevels;
            HierarchicalReferenceType type = HierarchicalReferenceType.OTHER;
            if (hid == null || !(this.holder instanceof HidHolder)) {
                return true;
            }
            if (!hid.hasAccesses()) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope instanceof RfFunction && holderScope.getName().equals(Check_2_1_9.this.connectPhaseMethodName)) {
                inConnectPhase = true;
            }
            if ((enclosingFunction = (RfFunction)holderScope.getEnclosingScope(RfFunction.class)) != null) {
                for (Pattern skipMethodPattern : Check_2_1_9.this.pSkipMethods) {
                    if (!skipMethodPattern.matcher(enclosingFunction.getFullName()).matches()) continue;
                    return true;
                }
            }
            if (hid.getParentHid() != null) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return true;
            }
            if (element instanceof RfThisImplicitVariable || element instanceof RfSuperImplicitVariable) {
                return true;
            }
            Check_2_1_9.this.notifyCheckAlive();
            if (element instanceof RfAssociatedType && (associatedType = LintUtils.getAssociatedFinalType((RfAssociatedType)element)) != null && associatedType instanceof RfClass) {
                type = Check_2_1_9.this.getReferenceType((RfClass)associatedType);
            }
            boolean isSpecialSequencer = false;
            if (type == HierarchicalReferenceType.SEQUENCER && (element.getName().equals("p_sequencer") || element.getName().equals("m_sequencer")) && (enclosingClass = (RfClass)holderScope.getEnclosingScope(RfClass.class)) != null && enclosingClass.isSubClass(Check_2_1_9.this.sequenceClassName, true)) {
                isSpecialSequencer = true;
            }
            ListContainer accesses = hid.getAccesses();
            for (HidAccess access : accesses) {
                if (access.getAccessKind() != 0 || access.getHids() == null) continue;
                ListContainer hids = access.getHids();
                for (Hid accessedHid : hids) {
                    RfNamedElement accessedAssociatedType;
                    if (accessedHid.getElement() instanceof RfFunction) {
                        boolean twoOrMoreLevelsOfParents;
                        Hid parentAccess = accessedHid.getParentHid();
                        boolean bl = twoOrMoreLevelsOfParents = parentAccess != null && parentAccess.getParentHid() != null;
                        if (!twoOrMoreLevelsOfParents && Check_2_1_9.this.allowedFunctions.contains(accessedHid.getElement())) {
                            this.getAllowedHidsFromMethodCall(accessedHid);
                            continue;
                        }
                    }
                    if (type == HierarchicalReferenceType.ROOT) {
                        if (accessedHid.getElement() instanceof RfFunction) {
                            boolean isSkippedClass;
                            String name = ((RfFunction)accessedHid.getElement()).getName();
                            RfClass enclosingClass2 = (RfClass)holderScope.getEnclosingScope(RfClass.class);
                            String enclosingClassName = "";
                            if (enclosingClass2 != null) {
                                enclosingClassName = enclosingClass2.getFullName();
                            }
                            boolean bl = isSkippedClass = Check_2_1_9.this.pClassesOfSkippedRootAPICalls.isEmpty() || Check_2_1_9.this.pClassesOfSkippedRootAPICalls.contains(enclosingClassName);
                            if (isSkippedClass && name != null && Check_2_1_9.this.pskipXVMRootAPICalls.contains(name)) {
                                return true;
                            }
                        }
                        Check_2_1_9.this.addHit(this.parserPath, (RfHid)accessedHid, MessageFormat.format(Check_2_1_9.XVM_ROOT_REFERENCES_ERROR_MESSAGE_FORMAT, OVMUtils.prependLibraryPrefixTo(Check_2_1_9.this.fOVMProject.getLibraryKind(), "_root"), String.valueOf(hid.getName()) + "." + accessedHid.getName()));
                        continue;
                    }
                    if (!(accessedHid instanceof RfHid) || accessedHid.getElement() instanceof RfFunction) continue;
                    Set<HidOccurrence> allowedOccurences = this.allowedHidsOccurence.get(this.parserPath);
                    HidOccurrence occurrence = accessedHid.getOccurrence();
                    if (allowedOccurences != null && allowedOccurences.contains(occurrence)) continue;
                    HierarchicalReferenceType accessedType = HierarchicalReferenceType.OTHER;
                    IRfNamedElement accessedElement = accessedHid.getElement();
                    if (accessedElement instanceof RfAssociatedType && (accessedAssociatedType = LintUtils.getAssociatedFinalType((RfAssociatedType)accessedElement)) instanceof RfClass) {
                        accessedType = Check_2_1_9.this.getReferenceType((RfClass)accessedAssociatedType);
                    }
                    if (type == HierarchicalReferenceType.SEQUENCER && accessedType == HierarchicalReferenceType.SEQUENCER && nofLevels > 0) {
                        this.visitAccesses(inConnectPhase, type, accessedType, accessedHid, --nofLevels);
                        continue;
                    }
                    if (accessedType == HierarchicalReferenceType.ROOT) {
                        if (accessedHid.getElement() instanceof RfFunction) {
                            boolean isSkippedClass;
                            String name = ((RfFunction)accessedHid.getElement()).getName();
                            RfClass enclosingClass3 = (RfClass)holderScope.getEnclosingScope(RfClass.class);
                            String enclosingClassName = "";
                            if (enclosingClass3 != null) {
                                enclosingClassName = enclosingClass3.getFullName();
                            }
                            boolean bl = isSkippedClass = Check_2_1_9.this.pClassesOfSkippedRootAPICalls.isEmpty() || Check_2_1_9.this.pClassesOfSkippedRootAPICalls.contains(enclosingClassName);
                            if (isSkippedClass && name != null && Check_2_1_9.this.pskipXVMRootAPICalls.contains(name)) {
                                return true;
                            }
                        }
                        Check_2_1_9.this.addHit(this.parserPath, (RfHid)accessedHid, MessageFormat.format(Check_2_1_9.XVM_ROOT_REFERENCES_ERROR_MESSAGE_FORMAT, OVMUtils.prependLibraryPrefixTo(Check_2_1_9.this.fOVMProject.getLibraryKind(), "_root"), String.valueOf(hid.getName()) + "." + accessedHid.getName()));
                        continue;
                    }
                    if (accessedType == HierarchicalReferenceType.PORT) continue;
                    if (!(inConnectPhase && accessedHid.hasAccesses() || isSpecialSequencer || type == HierarchicalReferenceType.OTHER && accessedType == HierarchicalReferenceType.OTHER)) {
                        Check_2_1_9.this.addHit(this.parserPath, (RfHid)accessedHid, MessageFormat.format(Check_2_1_9.EXCEEDING_REFERENCES_ERROR_MESSAGE_FORMAT, " '" + hid.getName() + "." + accessedHid.getName() + "'"));
                        continue;
                    }
                    this.visitAccesses(inConnectPhase, type, accessedType, accessedHid, nofLevels);
                }
            }
            return true;
        }

        private void visitAccesses(boolean inConnectPhase, HierarchicalReferenceType beforePreviousType, HierarchicalReferenceType previousType, Hid hid, int nofLevels) {
            if (hid == null || !(hid instanceof RfHid) || hid.getElement() instanceof RfFunction || hid.getAccesses() == null) {
                return;
            }
            for (HidAccess access : hid.getAccesses()) {
                if (access.getAccessKind() != 0 || access.getHids() == null) continue;
                for (Hid accessedHid : access.getHids()) {
                    IRfNamedElement accessedAssociatedType;
                    if (accessedHid == null || !(accessedHid instanceof RfHid) || accessedHid.getElement() instanceof RfFunction && !inConnectPhase) continue;
                    Set<HidOccurrence> allowedOccurences = this.allowedHidsOccurence.get(this.parserPath);
                    HidOccurrence occurrence = accessedHid.getOccurrence();
                    if (allowedOccurences != null && allowedOccurences.contains(occurrence)) continue;
                    HierarchicalReferenceType accessedType = HierarchicalReferenceType.OTHER;
                    IRfNamedElement accessedElement = accessedHid.getElement();
                    if (accessedElement instanceof RfAssociatedType && (accessedAssociatedType = ((RfAssociatedType)accessedElement).getAssociatedType()) instanceof RfClass) {
                        accessedType = Check_2_1_9.this.getReferenceType((RfClass)accessedAssociatedType);
                    }
                    if (accessedElement instanceof RfFunction) {
                        boolean twoOrMoreLevelsOfParents;
                        Hid parentAccess = accessedHid.getParentHid();
                        boolean bl = twoOrMoreLevelsOfParents = parentAccess != null && parentAccess.getParentHid() != null;
                        if (!twoOrMoreLevelsOfParents && Check_2_1_9.this.allowedFunctions.contains(accessedElement)) {
                            this.getAllowedHidsFromMethodCall(accessedHid);
                            continue;
                        }
                    }
                    if (previousType == HierarchicalReferenceType.SEQUENCER && accessedType == HierarchicalReferenceType.SEQUENCER && nofLevels > 0) {
                        this.visitAccesses(inConnectPhase, beforePreviousType, previousType, accessedHid, --nofLevels);
                        continue;
                    }
                    if (accessedType == HierarchicalReferenceType.ROOT) {
                        Check_2_1_9.this.addHit(this.parserPath, (RfHid)accessedHid, MessageFormat.format(Check_2_1_9.XVM_ROOT_REFERENCES_ERROR_MESSAGE_FORMAT, OVMUtils.prependLibraryPrefixTo(Check_2_1_9.this.fOVMProject.getLibraryKind(), "_root"), String.valueOf(hid.getName()) + "." + accessedHid.getName()));
                        continue;
                    }
                    if (!inConnectPhase) {
                        if (accessedType == HierarchicalReferenceType.OTHER && beforePreviousType == HierarchicalReferenceType.OTHER && previousType == HierarchicalReferenceType.OTHER) {
                            this.visitAccesses(inConnectPhase, beforePreviousType, previousType, accessedHid, nofLevels);
                            continue;
                        }
                        Check_2_1_9.this.addHit(this.parserPath, (RfHid)accessedHid, MessageFormat.format(Check_2_1_9.EXCEEDING_REFERENCES_ERROR_MESSAGE_FORMAT, ""));
                        continue;
                    }
                    if (accessedElement instanceof RfFunction) {
                        if (beforePreviousType == HierarchicalReferenceType.SEQUENCER && previousType == HierarchicalReferenceType.PORT && ((RfFunction)accessedElement).getFullName().equals(Check_2_1_9.this.connectMethodFullName) || beforePreviousType == HierarchicalReferenceType.OTHER && previousType == HierarchicalReferenceType.OTHER) continue;
                        Check_2_1_9.this.addHit(this.parserPath, (RfHid)accessedHid, MessageFormat.format(Check_2_1_9.EXCEEDING_REFERENCES_ERROR_MESSAGE_FORMAT, ""));
                        continue;
                    }
                    if (!accessedHid.hasAccesses()) {
                        Check_2_1_9.this.addHit(this.parserPath, (RfHid)accessedHid, MessageFormat.format(Check_2_1_9.EXCEEDING_REFERENCES_ERROR_MESSAGE_FORMAT, ""));
                        continue;
                    }
                    this.visitAccesses(inConnectPhase, previousType, accessedType, accessedHid, nofLevels);
                }
            }
        }

        private void getAllowedHidsFromMethodCall(Hid accessedHid) {
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)accessedHid);
            for (MethodCall methodCall : methodCalls) {
                Map argVals = methodCall.argumentValuesMapRaw;
                for (IHidObject argument : argVals.values()) {
                    if (!(argument instanceof RfHid)) continue;
                    HidOccurrence occurence = ((RfHid)argument).getOccurrence();
                    Set<HidOccurrence> occurences = this.allowedHidsOccurence.get(this.parserPath);
                    if (occurences == null) {
                        occurences = new HashSet<HidOccurrence>();
                    }
                    occurences.add(occurence);
                    Hid parentHid = ((RfHid)argument).getParentHid();
                    while (parentHid != null && parentHid instanceof RfHid) {
                        HidOccurrence parentOccurence = ((RfHid)parentHid).getOccurrence();
                        occurences.add(parentOccurence);
                        parentHid = ((RfHid)parentHid).getParentHid();
                    }
                    this.allowedHidsOccurence.put(this.parserPath, occurences);
                }
            }
        }
    }

    private final class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        private final RfProject rfProject;
        private final LocalHidVisitor hidVisitor;
        private OVMComplianceCheck check;

        private LocalNamedElementVisitor(RfProject rfProject, LocalHidVisitor hidVisitor, OVMComplianceCheck check) {
            this.rfProject = rfProject;
            this.hidVisitor = hidVisitor;
            this.check = check;
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            RfFileDef file = namedElement.getFile();
            if (file == null) {
                return true;
            }
            if (Check_2_1_9.this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this.check)) {
                return true;
            }
            if (!(namedElement.isPredefined() || namedElement instanceof RfLibrary || Check_2_1_9.this.fOVMProject.isOVMElement(namedElement))) {
                namedElement.visitHidObject(this.rfProject, this.hidVisitor);
            }
            return true;
        }
    }
}

