/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="16.1.32")
@CheckID(value="XVM.2.2.10")
@CheckName(value="XVM.2.2.10")
@CheckLabel(labels={RuleLabel.DRIVER, RuleLabel.SIGNAL, RuleLabel.ASSIGNMENT, RuleLabel.CLOCKING_BLOCK, RuleLabel.VERIFICATION})
@CheckTitle(value="Driver signal assignment must be non-blocking")
@CheckDescription(value="Driver shall assign value to clocking block signals using non-blocking assignment.\n\nCheck supports pre-waiving.")
public class Check_2_2_10
extends OVMComplianceCheck {
    private final HidOperatorVisitor fDriverVisitor = new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_BLOCKING_ASSIGN}){

        public boolean visitHit(HidOperator hidOperator, IRfNamedElement scope) {
            if (hidOperator.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                return true;
            }
            IHidObject lhHidObject = hidOperator.getLHValue();
            if (!(lhHidObject instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhHidObject;
            if (this.calledFromClockingBlock(lhHid)) {
                Check_2_2_10.this.addHit(this.parserPath, lhHid, "Signal '" + LintUtils.getHierarchicalPath(lhHid) + "' is assigned using a blocking assignment!");
            }
            return true;
        }

        private boolean calledFromClockingBlock(RfHid rfHid) {
            HidAccess parentAccess = rfHid.getParentAccess();
            if (parentAccess == null) {
                return false;
            }
            IRfNamedElement associatedType = parentAccess.getAssociatedType();
            if (associatedType instanceof RfAssociatedType) {
                associatedType = LintUtils.getAssociatedFinalType((RfAssociatedType)associatedType);
            }
            return associatedType != null && associatedType instanceof RfClockingBlock;
        }
    };

    public Check_2_2_10(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass component : this.fOVMProject.getAllComponents().values()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(component.getFile()) || !this.fOVMProject.isDriver(component)) continue;
            component.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)this.fDriverVisitor);
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

