/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.5")
@CheckID(value="XVM.2.2.11")
@CheckName(value="XVM.2.2.11")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.DRIVER, RuleLabel.INTERFACE, RuleLabel.SEQUENCER, RuleLabel.VERIFICATION})
@CheckTitle(value="Driver should only have a handle to interface and sequencer")
@CheckDescription(value="This check verifies that there are no other xvm_object handles in drivers except for interfaces and sequencers.\nIt also checks that there is at least one interface and one sequencer in all drivers.\n\nCheck supports pre-waiving.")
public class Check_2_2_11
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of class full names. Classes extending the base classes will be skipped", name="skipClassesExtendingBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipClassesExtendingBaseClasses;
    RfClass baseUvmObjectClass;
    RfClass baseDriverClass;
    RfClass baseSequencerClass;
    private Set<RfClass> skippedBaseClasses;

    public Check_2_2_11(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        this.baseUvmObjectClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object"), true);
        if (this.baseUvmObjectClass == null) {
            return;
        }
        this.baseDriverClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_driver"), true);
        if (this.baseDriverClass == null) {
            return;
        }
        this.baseSequencerClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequencer"), true);
        if (this.baseSequencerClass == null) {
            return;
        }
        Set<RfClass> components = this.baseDriverClass.getChildren();
        if (components == null) {
            return;
        }
        this.skippedBaseClasses = new HashSet<RfClass>();
        for (String baseClassName : this.pSkipClassesExtendingBaseClasses) {
            RfClass baseClass = this.fOVMProject.getRfProject().getClass(baseClassName, true);
            if (baseClass == null) continue;
            this.skippedBaseClasses.add(baseClass);
        }
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(this.baseDriverClass);
        for (RfClass component : components) {
            ParserPath classParserPath;
            RfFileDef file = component.getFile();
            if (file == null || (classParserPath = file.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            this.notifyCheckAlive();
            if (!this.fOVMProject.isOVMElement(component)) {
                if (LintUtils.isSubClassOfAny(component, this.skippedBaseClasses) || visited.contains(component = component.getGenericClass())) continue;
                visited.add(component);
            }
            this.checkChild(component, new HashSet<RfNamedElement>(), new HashSet<RfNamedElement>(), visited);
        }
    }

    private void checkChild(RfClass child, Set<RfNamedElement> interfacesInClassMap, Set<RfNamedElement> sequencersInClassMap, Set<RfClass> visited) {
        boolean isDriver = LintUtils.isSubClassOf(child, this.baseDriverClass);
        this.checkOnlyInterfaceAndSequencerInDriver(child, this.baseSequencerClass, this.baseUvmObjectClass, interfacesInClassMap, sequencersInClassMap, isDriver);
        Set<RfClass> components = child.getChildren();
        if (components == null) {
            return;
        }
        for (RfClass component : components) {
            ParserPath classParserPath;
            RfFileDef file = component.getFile();
            if (file == null || (classParserPath = file.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            this.notifyCheckAlive();
            if (!this.fOVMProject.isOVMElement(component)) {
                if (LintUtils.isSubClassOfAny(component, this.skippedBaseClasses) || visited.contains(component = component.getGenericClass())) continue;
                visited.add(component);
            }
            this.checkChild(component, interfacesInClassMap, sequencersInClassMap, visited);
        }
    }

    private void checkOnlyInterfaceAndSequencerInDriver(RfNamedElement component, RfClass baseSequencerClass, RfClass baseUvmObjectClass, Set<RfNamedElement> interfacesInClassMap, Set<RfNamedElement> sequencersInClassMap, boolean isDriver) {
        boolean hasSequencer = false;
        boolean hasVirtualInterface = false;
        List<RfField> fields = component.getFields();
        if (fields != null) {
            for (RfField field : fields) {
                if (field.isVirtualInterface()) {
                    hasVirtualInterface = true;
                    continue;
                }
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldType == null) continue;
                if (LintUtils.isSubClassOf(fieldType, baseSequencerClass)) {
                    hasSequencer = true;
                    continue;
                }
                if (!isDriver || !LintUtils.isSubClassOf(fieldType, baseUvmObjectClass)) continue;
                this.addHit(field, "Field of type " + fieldType.getFullName() + " used in driver '" + component.getFullName() + "'!");
            }
        }
        if (hasVirtualInterface) {
            interfacesInClassMap.add(component);
        }
        if (hasSequencer) {
            sequencersInClassMap.add(component);
        }
        if (!isDriver) {
            return;
        }
        List<Boolean> elementsInParent = this.checkElementsInParent(component, interfacesInClassMap, sequencersInClassMap, hasVirtualInterface, hasSequencer);
        Boolean hasInterfaceInParent = elementsInParent.get(0);
        Boolean hasSequencerInParent = elementsInParent.get(1);
        if (hasInterfaceInParent.booleanValue() && hasSequencerInParent.booleanValue()) {
            return;
        }
        if (!(hasSequencer || hasVirtualInterface || hasInterfaceInParent.booleanValue() || hasSequencerInParent.booleanValue())) {
            this.addHit(component, "Driver '" + component.getFullName() + "' does not have handle for sequencer and interface !");
            return;
        }
        if (!hasSequencer && !hasSequencerInParent.booleanValue()) {
            this.addHit(component, "Driver '" + component.getFullName() + "' does not have handle for sequencer!");
            return;
        }
        if (!hasVirtualInterface && !hasInterfaceInParent.booleanValue()) {
            this.addHit(component, "Driver '" + component.getFullName() + "' does not have handle for interface!");
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<Boolean> checkElementsInParent(RfNamedElement component, Set<RfNamedElement> interfacesInClassMap, Set<RfNamedElement> sequencersInClassMap, boolean hasVirtualInterface, boolean hasSequencer) {
        result = new ArrayList<Boolean>();
        parent = ((RfClass)component).getParent();
        if (parent != null) ** GOTO lbl18
        result.add(false);
        result.add(false);
        return result;
lbl-1000:
        // 1 sources

        {
            if (hasVirtualInterface && hasSequencer) {
                result.add(true);
                result.add(true);
                return result;
            }
            hasVirtualInterface = interfacesInClassMap.contains(parent) != false ? true : hasVirtualInterface;
            hasSequencer = sequencersInClassMap.contains(parent) != false ? true : hasSequencer;
            parent = parent.getParent();
lbl18:
            // 2 sources

            ** while (parent != null && !parent.equals((Object)this.baseDriverClass))
        }
lbl19:
        // 1 sources

        result.add(hasVirtualInterface);
        result.add(hasSequencer);
        return result;
    }
}

