/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractAnalysisPortCheck;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.2.3")
@CheckName(value="XVM.2.2.3")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.DRIVER, RuleLabel.ANALYSIS_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Driver Has Analysis Port")
@CheckDescription(value="At least one analysis port must be provided in the driver class into which the sequence item should be placed with each item operation.\nThis allows analysis components to connect directly to the driver in case a monitor is unable to fully reconstruct the item.\nExample:\n...\ntask run();\n  forever begin\n    seq_item_port.get_next_item(item);\n    request_analysis_port.write(item);\n    ...\n  end\nendtask: run")
public class Check_2_2_3
extends AbstractAnalysisPortCheck {
    public Check_2_2_3(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fDrivers.isEmpty()) {
            return;
        }
        this.checkAnalysisPort(this.fOVMProject.fDrivers.values(), "driver");
    }
}

