/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractAnalysisPortCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="20.1.8")
@CheckID(value="XVM.2.2.3.1")
@CheckName(value="XVM.2.2.3.1")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.DRIVER, RuleLabel.ANALYSIS_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Driver should not have analysis port")
@CheckDescription(value="Classes that extend from xvm_driver should not have analysis port because, in some situations, this is not necessary.\n\nCheck supports pre-waiving.")
public class Check_2_2_3_1
extends AbstractAnalysisPortCheck {
    Set<RfClass> visited = new HashSet<RfClass>();

    public Check_2_2_3_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        this.visited.clear();
        String library = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "");
        RfClass rfClass = this.fOVMProject.getRfProject().getClass(String.valueOf(library) + "_pkg::" + library + "_driver", true);
        if (rfClass == null) {
            return;
        }
        Set<RfClass> components = rfClass.getChildren();
        if (components == null) {
            return;
        }
        this.visited.add(rfClass);
        this.checkAnalysisPort(components, "driver");
    }

    @Override
    protected void checkAnalysisPort(Collection<RfClass> components, String componentText) {
        if (components == null) {
            return;
        }
        for (RfClass component : components) {
            this.notifyCheckAlive();
            if (component == null || this.visited.contains(component)) continue;
            this.visited.add(component);
            RfClass currentClass = component;
            RfFileDef file = currentClass.getFile();
            if (file == null) continue;
            this.checkAnalysisPort(currentClass.getChildren(), componentText);
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            ArrayList<RfField> allFieldsWithAnalysisPort = new ArrayList<RfField>();
            List<RfField> tempFields = this.checkIfAnalysisPortExist(currentClass, componentText, false);
            if (tempFields != null && !tempFields.isEmpty()) {
                allFieldsWithAnalysisPort.addAll(tempFields);
            }
            for (RfField field : allFieldsWithAnalysisPort) {
                this.addHit(field, String.valueOf(DVTStringUtil.capitalizeFirstLetter((String)this.getLibAnalysisPortName())) + " '" + LintUtils.getNamedElementFullName(field) + "' was found in " + componentText + " '" + component.getName() + "'!");
            }
        }
    }

    @Override
    public void clean() {
        super.clean();
        if (this.visited != null) {
            this.visited.clear();
        }
    }
}

