/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="17.1.24")
@CheckID(value="XVM.2.3.8")
@CheckName(value="XVM.2.3.8")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.ASSIGNMENT, RuleLabel.INTERFACE, RuleLabel.VERIFICATION})
@CheckTitle(value="A monitor should not assign values to interface members")
@CheckDescription(value="A monitor should passively watch an interface and from it create transactions, which it sends out through an analysis port for further processing by DUT-specific (or subsystem-specific) components. A monitor should always be written as a passive component and its execution should never be blocked by another UVM component or sequence.")
public class Check_2_3_8
extends OVMComplianceCheck {
    public Check_2_3_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> monitors = this.fOVMProject.fMonitors;
        if (monitors == null) {
            return;
        }
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            this.checkIfMonitorAssignesToInterface(monitor);
        }
    }

    private void checkIfMonitorAssignesToInterface(RfClass monitor) {
        this.notifyCheckAlive();
        monitor.visitHidObject(null, new IHidVisitor<IHidOperator>(){
            private ParserPath parserPath;

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(IHidOperator hidOperator) {
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator operator = (RfHidOperator)hidOperator;
                if (!operator.isAssignment()) {
                    return true;
                }
                IHidObject lhValue = operator.getLHValue();
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                RfHid rfHid = (RfHid)((RfHid)lhValue).getParentHid();
                while (rfHid != null) {
                    IRfNamedElement element = rfHid.getElement();
                    if (!(element instanceof RfField)) {
                        return true;
                    }
                    if (((RfField)element).isVirtualInterface() || element instanceof RfInstance && ((RfInstance)element).getAssociatedType() instanceof RfInterface) {
                        HidOperatorOccurrence occurence = hidOperator.getOccurrence();
                        if (occurence == null) {
                            return true;
                        }
                        Check_2_3_8.this.addHit(this.parserPath, occurence.getLine(), "Value assigned to interface member '" + HidUtils.toStringBuilder((IHidObject)lhValue, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)true).toString() + "' from within a monitor!", null);
                        break;
                    }
                    rfHid = (RfHid)rfHid.getParentHid();
                }
                return true;
            }

            public Class<IHidOperator> getType() {
                return IHidOperator.class;
            }
        });
    }
}

