/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.3.8.1")
@CheckName(value="XVM.2.3.8.1")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.INTERFACE, RuleLabel.SIGNAL, RuleLabel.PORT, RuleLabel.MODPORT, RuleLabel.VERIFICATION})
@CheckTitle(value="A monitor shall access interface signals only through the input ports of a 'mon_mp' modport")
@CheckDescription(value="The 'mon_mp' port directions should all be configured to input.\n This simulation runtime checks ensure that the monitor will never drive the bus.")
public class Check_2_3_8_1
extends OVMComplianceCheck {
    public Check_2_3_8_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> allMonitors = this.fOVMProject.fMonitors;
        if (allMonitors.isEmpty()) {
            return;
        }
        RfProject rfProject = this.fOVMProject.getRfProject();
        RfHidVisitor hidVisitor = new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (hid != null) {
                    RfField designUnitPort;
                    if (!hid.hasQualifier(HidQualifierCache.LAST_QUALIFIER)) {
                        return true;
                    }
                    HidAccess parentAccess = hid.getParentAccess();
                    if (parentAccess == null) {
                        return true;
                    }
                    Hid parentHid = parentAccess.getParentHid();
                    if (parentHid == null) {
                        return true;
                    }
                    IRfNamedElement hidNamedElement = hid.getElement();
                    if (hidNamedElement == null || !(hidNamedElement instanceof RfField)) {
                        return true;
                    }
                    RfNamedElement hidEnclosingScope = ((RfNamedElement)hidNamedElement).getEnclosingScope();
                    if (hidEnclosingScope == null) {
                        return true;
                    }
                    String hierarchicalPath = HidUtils.toString((IHidObject)hid, (boolean)true, (boolean)true);
                    if (hidEnclosingScope instanceof RfInterface) {
                        if (!(hidNamedElement instanceof RfModport)) {
                            IRfNamedElement parentHidNamedElement = parentHid.getElement();
                            if (!(parentHidNamedElement instanceof RfModport)) {
                                Check_2_3_8_1.this.addHit(this.parserPath, hid, "Illegal direct interface access: '" + hierarchicalPath + "'!");
                            } else if (!"mon_mp".equals(parentHidNamedElement.getName())) {
                                Check_2_3_8_1.this.addHit(this.parserPath, hid, "Illegal modport name: '" + hierarchicalPath + "'!");
                            } else if (!((RfField)hidNamedElement).isInput()) {
                                Check_2_3_8_1.this.addHit(this.parserPath, hid, "Illegal port direction: '" + hierarchicalPath + "'!");
                            }
                        }
                    } else if (hidEnclosingScope instanceof RfModport) {
                        if (!"mon_mp".equals(hidEnclosingScope.getName())) {
                            Check_2_3_8_1.this.addHit(this.parserPath, hid, "Illegal modport name: '" + hierarchicalPath + "'!");
                        } else if (!((RfField)hidNamedElement).isInput()) {
                            Check_2_3_8_1.this.addHit(this.parserPath, hid, "Illegal port direction: '" + hierarchicalPath + "'!");
                        }
                    } else if (hidEnclosingScope instanceof RfClockingBlock && hidNamedElement instanceof RfModportPort && (designUnitPort = ((RfModportPort)hidNamedElement).getDesignUnitPort()) != null && designUnitPort.getEnclosingScope() instanceof RfInterface) {
                        Check_2_3_8_1.this.addHit(this.parserPath, hid, "Illegal direct interface access: '" + hierarchicalPath + "'!");
                    }
                }
                return true;
            }
        };
        for (RfClass monitor : allMonitors.values()) {
            if (monitor == null) continue;
            this.notifyCheckAlive();
            monitor.visitHidObject(rfProject, hidVisitor);
        }
    }
}

