/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="20.1.26")
@CheckID(value="XVM.2.3.9")
@CheckName(value="XVM.2.3.9")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.SCOREBOARD, RuleLabel.MONITOR, RuleLabel.REGISTER_BLOCK, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use reg handles in scoreboards and monitors")
@CheckDescription(value="This rule checks existence of xvm_reg_block (or any child of this class) fields in classes that extend from xvm_monitor or xvm_scoreboard.\n\nCheck supports pre-waiving.")
public class Check_2_3_9
extends OVMComplianceCheck {
    private static final String UVM_MONITOR = "uvm_pkg::uvm_monitor";
    private static final String OVM_MONITOR = "ovm_pkg::ovm_monitor";
    private static final String UVM_SCOREBOARD = "uvm_pkg::uvm_scoreboard";
    private static final String OVM_SCOREBOARD = "ovm_pkg::ovm_scoreboard";
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private static final String OVM_REG_BLOCK = "ovm_pkg::ovm_reg_block";
    HashSet<RfClass> visitedClasses = new HashSet();
    List<RfClass> targetedClasses;
    RfClass xvmRegBlock;

    public Check_2_3_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.visitedClasses.clear();
        this.targetedClasses = new ArrayList<RfClass>();
        if (this.fOVMProject.getLibraryKind() == 2) {
            RfClass uvmScoreboard;
            RfClass uvmMonitor = this.fOVMProject.getRfProject().getClass(UVM_MONITOR, true);
            if (uvmMonitor != null) {
                this.targetedClasses.add(uvmMonitor);
            }
            if ((uvmScoreboard = this.fOVMProject.getRfProject().getClass(UVM_SCOREBOARD, true)) != null) {
                this.targetedClasses.add(uvmScoreboard);
            }
            this.xvmRegBlock = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        } else {
            RfClass ovmScoreboard;
            RfClass ovmMonitor = this.fOVMProject.getRfProject().getClass(OVM_MONITOR, true);
            if (ovmMonitor != null) {
                this.targetedClasses.add(ovmMonitor);
            }
            if ((ovmScoreboard = this.fOVMProject.getRfProject().getClass(OVM_SCOREBOARD, true)) != null) {
                this.targetedClasses.add(ovmScoreboard);
            }
            this.xvmRegBlock = this.fOVMProject.getRfProject().getClass(OVM_REG_BLOCK, true);
        }
        ArrayList<RfClass> projectClasses = new ArrayList<RfClass>();
        for (RfClass targetedClass : this.targetedClasses) {
            if (targetedClass.getChildren() == null) continue;
            projectClasses.addAll(targetedClass.getChildren());
        }
        this.checkClasses(projectClasses);
    }

    private void checkClasses(Collection<RfClass> projectClasses) {
        for (RfClass currentClass : projectClasses) {
            Set<RfClass> children;
            ParserPath classParserPath;
            if (currentClass == null || this.visitedClasses.contains(currentClass)) continue;
            this.visitedClasses.add(currentClass);
            RfFileDef classFile = currentClass.getFile();
            if (classFile == null || (classParserPath = classFile.getParserPath()) == null) continue;
            if (!this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) {
                this.notifyCheckAlive();
                List<RfField> fields = currentClass.getFields();
                if (fields == null) continue;
                for (RfField field : fields) {
                    RfClass fieldType;
                    if (field == null || (fieldType = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || !LintUtils.isSubClassOf(fieldType, this.xvmRegBlock)) continue;
                    this.addHit(field, "Field '" + LintUtils.getNamedElementFullName(field) + "' of type '" + fieldType.getName() + "' is not allowed in scoreboards or monitors!");
                }
            }
            if ((children = currentClass.getChildren()) == null || children.isEmpty()) continue;
            this.checkClasses(children);
        }
    }
}

