/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsBeginEndMacroCheck;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.4.4")
@CheckName(value="XVM.2.4.4")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION_MACRO, RuleLabel.SEQUENCER, RuleLabel.VERIFICATION})
@CheckTitle(value="Factory registration macros for sequencers")
@CheckDescription(value="The sequencer must register with the factory.\nFor non-parameterized sequencers:\n`xvm_component_utils(my_sequencer)\nFor parameterized sequencers:\n`xvm_component_param_utils(my_sequencer#(my_params))\nRegistering with the factory is required for item creation and easy item overriding.\n\nImplementation Notes:\nThe first macro argument is checked.")
public class Check_2_4_4
extends AbstractUtilsBeginEndMacroCheck {
    public Check_2_4_4(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequencers.isEmpty()) {
            return;
        }
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        HashSet<String> libComponentsUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_utils") : Arrays.asList("`uvm_component_utils", "`uvm_component_abstract_utils"));
        HashSet<String> libComponentsParamUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_param_utils") : Arrays.asList("`uvm_component_param_utils", "`uvm_component_abstract_param_utils"));
        HashSet<String> libComponentsUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_utils_begin") : Arrays.asList("`uvm_component_utils_begin", "`uvm_component_abstract_utils_begin"));
        String libComponentsUtilsEnd = isOVMLib ? "`ovm_component_utils_end" : "`uvm_component_utils_end";
        HashSet<String> libComponentsParamUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_param_utils_begin") : Arrays.asList("`uvm_component_param_utils_begin", "`uvm_component_abstract_param_utils_begin"));
        this.checkMacros(this.fOVMProject.fSequencers, libComponentsUtils, libComponentsParamUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtilsBegin, true, false);
    }
}

