/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Collection;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractBaseClassCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.5.2")
@CheckName(value="XVM.2.5.2")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.VIRTUAL_SEQUENCER, RuleLabel.VERIFICATION})
@CheckTitle(value="Virtual Sequencer Base Class")
@CheckDescription(value="A virtual sequencer must extend the xvm_sequencer base class typed to the xvm_sequence_item class.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="baseClass", defaultValue="xvm_pkg::xvm_sequencer")
public class Check_2_5_2
extends AbstractBaseClassCheck {
    @CheckParameter(defaultValue="false", description="When true, virtual sequencers will be considered as sequencers with default parameters.", name="allowVirtualSequencersWithDefaultParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowVirtualSequencersWithDefaultParameters;

    public Check_2_5_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getComponentName() {
        return "virtual sequencer";
    }

    @Override
    protected Collection<RfClass> getComponents() {
        NullProtectedList<RfClass> virtualSequencers;
        if (this.pAllowVirtualSequencersWithDefaultParameters) {
            virtualSequencers = new NullProtectedList();
            for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
                if (!(clazz instanceof RfClass) || !LintUtils.isVirtualSequencer((RfClass)clazz, this.fOVMProject.fOvmSequencer, this.fOVMProject.fOvmSequenceItem)) continue;
                virtualSequencers.add((RfClass)clazz);
            }
        } else {
            virtualSequencers = this.fOVMProject.getVirtualSequencers().values();
        }
        return virtualSequencers;
    }

    @Override
    protected RfClass getBaseClass() {
        if (!this.pBaseClassValue.isEmpty()) {
            return this.fOVMProject.getRfProject().getClass(this.pBaseClassValue, true);
        }
        return this.fOVMProject.fOvmSequencer;
    }
}

