/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_Names;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractNameCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.6.1")
@CheckName(value="XVM.2.6.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.AGENT, RuleLabel.CLASS, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="Agent Class Name")
@CheckDescription(value="An agent class name must end with the '_agent' suffix.\n\nExamples for default suffix = '_agent':\nclass my_agent extends uvm_agent; endclass // allowed\nclass my_class extends uvm_agent; endclass // not allowed\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_XVM_Names.class)
@CheckParameterOverride(name="suffix", defaultValue="_agent", isVisible=true)
public class Check_2_6_1
extends AbstractNameCheck {
    public Check_2_6_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getHitMessage(RfNamedElement component, String suffixes) {
        return "Agent '" + component.getName() + "' must have one of the following suffixes: " + suffixes + "!";
    }

    @Override
    protected Map<String, RfClass> getComponents() {
        return this.fOVMProject.fAgents;
    }
}

