/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="18.1.37")
@CheckID(value="XVM.2.6.3")
@CheckName(value="XVM.2.6.3")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.DRIVER, RuleLabel.SEQUENCER, RuleLabel.CONFIG_OBJECT, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Agents should contain a monitor, driver, sequencer and configuration object")
@CheckDescription(value="All agents should have only the following class member variables:\n - [mandatory] uvm_driver derived member\n - [mandatory] uvm_monitor derived member\n - [mandatory] uvm_sequencer derived member\n - [optional] uvm_object derived configuration member matching <configurationObjectNamePattern>\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="configurationObjectClassNamePattern", isVisible=true)
public class Check_2_6_3
extends AbstractNamePatternParametersCheck {
    @CheckParameter(defaultValue="", description="The configuration object field name pattern.", name="configurationObjectNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pConfigurationObjectNamePatternValue;
    @CheckParameter(defaultValue="", description="Driver field name pattern.", name="driverNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pDriverNamePatternValue;
    @CheckParameter(defaultValue="", description="Monitor field name pattern.", name="monitorNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pMonitorNamePatternValue;
    @CheckParameter(defaultValue="", description="Sequencer field name pattern.", name="sequencerNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pSequencerNamePatternValue;
    @CheckParameter(defaultValue="false", description="When true, fields of type xvm_sequencer are allowed.", name="allowXVMSequencer", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowXVMSequencer;
    @CheckParameter(defaultValue="false", description="When true, inherited class fields are allowed. Inherited class fields cannot be reported as additional fields.", name="allowInheritedFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowInheritedFields;
    @CheckParameter(defaultValue="false", description="When true, additional class fields are allowed.", name="allowAditionalFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowAditionalFields;
    @CheckParameter(defaultValue="", description="Comma separated list of base classes full names. Fields of type that inherit from these base classes will be allowed", name="allowFieldTypeBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowSpecifiedFields;
    private final Map<String, Boolean> hasField = new HashMap<String, Boolean>();

    public Check_2_6_3(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<RfClass> fieldTypeBaseClasses = new HashSet<RfClass>();
        for (String specifiedField : this.pAllowSpecifiedFields) {
            RfClass clazz = this.fOVMProject.getRfProject().getClass(specifiedField, true);
            if (clazz == null) {
                this.signalParamError("Base class: " + specifiedField + " specified for 'allowFieldTypeBaseClasses' does not exist!", false);
                break;
            }
            fieldTypeBaseClasses.add(clazz);
        }
        Collection<RfClass> allAgents = this.fOVMProject.fAgents.values();
        if (allAgents == null || allAgents.isEmpty()) {
            return;
        }
        for (RfClass agent : allAgents) {
            this.hasField.clear();
            this.hasField.put("driver", false);
            this.hasField.put("monitor", false);
            this.hasField.put("sequencer", false);
            this.hasField.put("object", false);
            if (this.checkPreWaivers(agent.getFile())) continue;
            List<RfField> agentFields = null;
            agentFields = !this.pAllowInheritedFields ? agent.getFields() : agent.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (agentFields == null || agentFields.isEmpty()) {
                this.addHit(agent, "Agent '" + LintUtils.getNamedElementFullName(agent) + "' is missing the " + this.getMissingMembers() + " or the existing members do not match the corresponding pattern!");
                continue;
            }
            this.notifyCheckAlive();
            ArrayList<RfField> illegalMembers = new ArrayList<RfField>();
            for (RfField field : agentFields) {
                Matcher m;
                RfNamedElement associatedType = LintUtils.getAssociatedFinalType(field);
                if (!(associatedType instanceof RfClass)) {
                    this.addIllegalMember(illegalMembers, field, agent);
                    continue;
                }
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldType == null) {
                    this.addIllegalMember(illegalMembers, field, agent);
                    continue;
                }
                if (this.fOVMProject.isMonitor(fieldType)) {
                    if (this.hasField.get("monitor").booleanValue()) {
                        this.addIllegalMember(illegalMembers, field, agent);
                        continue;
                    }
                    if (!this.pMonitorNamePatternValue.pattern().isEmpty()) {
                        m = this.pMonitorNamePatternValue.matcher(field.getName());
                        if (m.matches()) {
                            this.hasField.put("monitor", true);
                            continue;
                        }
                        this.addIllegalMember(illegalMembers, field, agent);
                        continue;
                    }
                    this.hasField.put("monitor", true);
                    continue;
                }
                if (this.fOVMProject.isDriver(fieldType)) {
                    if (this.hasField.get("driver").booleanValue()) {
                        this.addIllegalMember(illegalMembers, field, agent);
                        continue;
                    }
                    if (!this.pDriverNamePatternValue.pattern().isEmpty()) {
                        m = this.pDriverNamePatternValue.matcher(field.getName());
                        if (m.matches()) {
                            this.hasField.put("driver", true);
                            continue;
                        }
                        this.addIllegalMember(illegalMembers, field, agent);
                        continue;
                    }
                    this.hasField.put("driver", true);
                    continue;
                }
                if (this.pAllowXVMSequencer ? this.fOVMProject.isSequencerOrTheSequencerBaseClass(fieldType) : this.fOVMProject.isSequencer(fieldType)) {
                    if (this.hasField.get("sequencer").booleanValue()) {
                        this.addIllegalMember(illegalMembers, field, agent);
                        continue;
                    }
                    if (!this.pSequencerNamePatternValue.pattern().isEmpty()) {
                        m = this.pSequencerNamePatternValue.matcher(field.getName());
                        if (m.matches()) {
                            this.hasField.put("sequencer", true);
                            continue;
                        }
                        this.addIllegalMember(illegalMembers, field, agent);
                        continue;
                    }
                    this.hasField.put("sequencer", true);
                    continue;
                }
                if (this.getClassesWithPatterns("configurationObjectClassNamePattern").containsKey(fieldType.getFullName())) {
                    if (this.hasField.get("object").booleanValue()) {
                        illegalMembers.add(field);
                        continue;
                    }
                    if (!this.pConfigurationObjectNamePatternValue.pattern().isEmpty()) {
                        m = this.pConfigurationObjectNamePatternValue.matcher(field.getName());
                        if (m.matches()) {
                            this.hasField.put("object", true);
                            continue;
                        }
                        this.addIllegalMember(illegalMembers, field, agent);
                        continue;
                    }
                    this.hasField.put("object", true);
                    continue;
                }
                if (LintUtils.isSubClassOfAny(fieldType, fieldTypeBaseClasses)) continue;
                this.addIllegalMember(illegalMembers, field, agent);
            }
            if (this.hasField.get("driver").booleanValue() && this.hasField.get("monitor").booleanValue() && this.hasField.get("sequencer").booleanValue() && illegalMembers.isEmpty()) continue;
            String missingMembers = this.getMissingMembers();
            if (!missingMembers.isEmpty() && (this.pAllowAditionalFields || illegalMembers.isEmpty())) {
                this.addHit(agent, "Agent '" + LintUtils.getNamedElementFullName(agent) + "' is missing the " + missingMembers + " or the existing members do not match the corresponding pattern!");
                continue;
            }
            if (!(this.pAllowAditionalFields || missingMembers.isEmpty() || illegalMembers.isEmpty())) {
                this.addHit(agent, "Agent '" + LintUtils.getNamedElementFullName(agent) + "' is missing the " + missingMembers + " or the existing members do not match the corresponding pattern and has the additional members " + this.getIllegalMembers(illegalMembers) + "!");
                continue;
            }
            if (this.pAllowAditionalFields || !missingMembers.isEmpty() || illegalMembers.isEmpty()) continue;
            this.addHit(agent, "Agent '" + LintUtils.getNamedElementFullName(agent) + "' has the additional members " + this.getIllegalMembers(illegalMembers) + "!");
        }
    }

    private void addIllegalMember(List<RfField> illegalMembers, RfField field, RfClass agent) {
        if (field.getDeclaration() != null && field.getDeclaration().getReparseInfo() != null && this.fOVMProject.isReparseStackInOVMFile(field.getDeclaration().getReparseInfo())) {
            return;
        }
        if (!this.pAllowInheritedFields || agent.equals(field.getEnclosingScope())) {
            illegalMembers.add(field);
        }
    }

    private String getIllegalMembers(List<RfField> illegalMembers) {
        if (illegalMembers == null || illegalMembers.isEmpty()) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        for (RfField illegalMember : illegalMembers) {
            text.append("'").append(illegalMember.getName()).append("', ");
        }
        text.replace(text.length() - 2, text.length(), "");
        return text.toString();
    }

    private String getMissingMembers() {
        StringBuilder text = new StringBuilder();
        for (Map.Entry<String, Boolean> field : this.hasField.entrySet()) {
            if (field.getKey().equals("object") || field.getValue().booleanValue()) continue;
            text.append("'").append(field.getKey()).append("', ");
        }
        if (text.length() != 0) {
            text.replace(text.length() - 2, text.length(), "");
        }
        return text.toString();
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

