/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.6.5")
@CheckName(value="XVM.2.6.5")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.AGENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Forbidden Agent Run Phase")
@CheckDescription(value="An agent doesn't run anything - it only exists as a hierarchical element.")
public class Check_2_6_5
extends OVMComplianceCheck {
    public Check_2_6_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String xvmRunPhaseMethodName = this.fOVMProject.getRunPhaseMethodName();
        Map<String, RfClass> agents = this.fOVMProject.fAgents;
        for (RfClass agent : agents.values()) {
            if (agent == null) continue;
            this.notifyCheckAlive();
            ArrayList<RfFunction> functions = new ArrayList<RfFunction>();
            List<RfFunction> localFunctionsAndTasks = agent.getLocalMembers(RfFunction.class);
            if (localFunctionsAndTasks != null) {
                functions.addAll(localFunctionsAndTasks);
            }
            boolean isFailure = false;
            for (RfFunction function : functions) {
                if (function == null || !function.getName().equals(xvmRunPhaseMethodName)) continue;
                this.addHit(function, "'" + xvmRunPhaseMethodName + "()' is overridden in '" + agent.getName() + "'!");
                isFailure = true;
            }
            if (isFailure) continue;
            this.addPassedHit(agent, String.valueOf(xvmRunPhaseMethodName) + "() method not used in '" + agent.getName() + "' agent!");
        }
    }
}

