/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.7.3")
@CheckName(value="XVM.2.7.3")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.ENVIRONMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Forbidden Env Run Phase")
@CheckDescription(value="An environment doesn't run anything - it only exists as a hierarchical element.")
public class Check_2_7_3
extends OVMComplianceCheck {
    public Check_2_7_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String xvmRunPhaseMethodName = this.fOVMProject.getRunPhaseMethodName();
        Map<String, RfClass> envs = this.fOVMProject.fEnvs;
        for (RfClass env : envs.values()) {
            if (env == null) continue;
            this.notifyCheckAlive();
            ArrayList<RfFunction> functions = new ArrayList<RfFunction>();
            List<RfFunction> localFunctionsAndTasks = env.getLocalMembers(RfFunction.class);
            if (localFunctionsAndTasks != null) {
                functions.addAll(localFunctionsAndTasks);
            }
            boolean isFailure = false;
            for (RfFunction function : functions) {
                if (function == null || !function.getName().equals(xvmRunPhaseMethodName)) continue;
                this.addHit(function, "'" + xvmRunPhaseMethodName + "()' is overridden in '" + env.getName() + "'!");
                isFailure = true;
            }
            if (isFailure) continue;
            this.addPassedHit(env, String.valueOf(xvmRunPhaseMethodName) + "() method not used in '" + env.getName() + "' environment!");
        }
    }
}

