/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.8.3")
@CheckName(value="XVM.2.8.3")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.TEST, RuleLabel.ENVIRONMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Common testcase base class constructs the environment")
@CheckDescription(value="A single base test class shall be declared that constructs the environment. This reduces the lines of code required for individual test cases. All other test classes must extend the base test class.\nBy default the rule defines a base test class as a class that directly inherits from xvm_test. \nYou can have multiple base test classes if you define a value for the baseTestNamePattern parameter.\n\nCheck supports pre-waiving.")
public class Check_2_8_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="All classes matching this pattern are considered test classes.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePattern;
    @CheckParameter(defaultValue=".*", description="All base test classes should match this pattern.", name="baseTestNamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pBaseTestNamePattern;

    public Check_2_8_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String libTestName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_test");
        RfClass fTestClass = this.fOVMProject.getRfProject().getClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::" + libTestName), true);
        HashSet<RfClass> classes = new HashSet<RfClass>();
        for (RfClass rfClass : this.fOVMProject.getAllClasses()) {
            this.notifyCheckAlive();
            if (rfClass.equals(fTestClass) || !LintUtils.isSubClassOf(rfClass, fTestClass) && !this.pNamePattern.matcher(rfClass.getName()).matches()) continue;
            classes.add(rfClass);
        }
        if (classes.isEmpty()) {
            return;
        }
        HashSet<RfClass> baseClasses = new HashSet<RfClass>();
        for (RfClass clazz : classes) {
            RfClass parent = clazz.getParent();
            if (this.pBaseTestNamePattern.pattern().equals(".*")) {
                if (parent == null || !parent.getName().equals(libTestName)) continue;
                baseClasses.add(clazz);
                continue;
            }
            if (!this.pBaseTestNamePattern.matcher(clazz.getName()).matches()) continue;
            baseClasses.add(clazz);
        }
        if (this.pBaseTestNamePattern.pattern().equals(".*") && baseClasses.size() > 1) {
            for (RfClass baseClass : baseClasses) {
                this.addHit(baseClass, "Test class '" + LintUtils.getNamedElementFullName(baseClass) + "' is not the only base class!");
            }
            return;
        }
        for (RfClass clazz : classes) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(clazz.getFile()) || baseClasses.contains(clazz) || LintUtils.isSubClassOfAny(clazz, baseClasses)) continue;
            this.addHit(clazz, "Test class '" + LintUtils.getNamedElementFullName(clazz) + "' does not extend a base class!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

