/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.8.5")
@CheckName(value="XVM.2.8.5")
@CheckLabel(labels={RuleLabel.FACTORY_OVERRIDE, RuleLabel.BUILD_PHASE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Set type overrides only in the build phase method")
@CheckDescription(value="Type overrides should only occur in the build phase method of the testcase (or base testcase).\nHaving type overrides elsewhere makes debug difficult / confusing.\nThe <baseClassMethods> and the <noParentMethods> parameters can be used to specify additional allowed methods.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_2_8_5
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, the type overrides are allowed in a function called from the specified base class methods.", name="allowIndirectCallOverride", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowIndirectCallOverrideValue;
    @CheckParameter(defaultValue="xvm_pkg::xvm_test", description="Comma separated list of base classes, check that type overrides are called only in the build_phase of classes that inherit from them.", name="baseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pBaseClasses;
    @CheckParameter(defaultValue="build,build_phase", description="Comma separated list of method names, check that type overrides are called only in class methods with these names.", name="baseClassMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pBaseClassMethods;
    @CheckParameter(defaultValue="false", description="When true, the type overrides are allowed in classes which do not inherit from another class.", name="allowNoParentClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowNoParentClasses;
    @CheckParameter(defaultValue="", description="Comma separated list of method names, check that type overrides are called only in class methods with these names. Only applies for classes which do not inherit from another class. If left empty, type overrides can be called from all methods.", name="noParentMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pNoParentMethods;
    private static final Set<String> TYPE_OVERRIDE_FUNCTIONS = new HashSet<String>();
    private Map<ParserPath, Set<HidInfo>> typeOverrideCalls;

    static {
        TYPE_OVERRIDE_FUNCTIONS.add("set_type_override");
        TYPE_OVERRIDE_FUNCTIONS.add("set_inst_override");
        TYPE_OVERRIDE_FUNCTIONS.add("set_inst_override_by_type");
        TYPE_OVERRIDE_FUNCTIONS.add("set_inst_override_by_name");
        TYPE_OVERRIDE_FUNCTIONS.add("set_type_override_by_type");
        TYPE_OVERRIDE_FUNCTIONS.add("set_type_override_by_name");
    }

    public Check_2_8_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.typeOverrideCalls = new HashMap<ParserPath, Set<HidInfo>>();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (Check_2_8_5.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                Check_2_8_5.this.notifyCheckAlive();
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (!TYPE_OVERRIDE_FUNCTIONS.contains(element.getName())) {
                    return true;
                }
                IRfNamedElement scope = ((HidHolder)this.holder).getScope();
                if (scope == null) {
                    return true;
                }
                RfClass classScope = (RfClass)scope.getEnclosingScope(RfClass.class);
                if (classScope == null) {
                    return true;
                }
                Set<HidInfo> calls = Check_2_8_5.this.typeOverrideCalls.get(this.parserPath);
                if (calls == null) {
                    calls = new HashSet<HidInfo>();
                    Check_2_8_5.this.typeOverrideCalls.put(this.parserPath, calls);
                }
                calls.add(new HidInfo(hidObject, classScope));
                return true;
            }
        });
        HashSet<RfClass> classesToCheck = new HashSet<RfClass>();
        LinkedList<RfClass> classesQueue = new LinkedList<RfClass>();
        for (String baseClass : this.pBaseClasses) {
            RfClass baseRfClass = this.fOVMProject.getRfProject().getClass(baseClass, true);
            if (baseRfClass == null) continue;
            classesQueue.add(baseRfClass);
        }
        while (classesQueue.peek() != null) {
            RfClass localClass = (RfClass)classesQueue.poll();
            classesToCheck.add(localClass);
            Set<RfClass> set = localClass.getChildren();
            if (set == null) continue;
            for (RfClass childClass : set) {
                if (childClass == null) continue;
                classesQueue.add(childClass);
            }
        }
        HashSet<RfClass> noParrentClasses = new HashSet<RfClass>();
        if (this.pAllowNoParentClasses) {
            for (RfNamedElement rfNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
                if (!(rfNamedElement instanceof RfClass) || ((RfClass)rfNamedElement).getParent() != null) continue;
                noParrentClasses.add((RfClass)rfNamedElement);
            }
        }
        for (RfClass rfClass : classesToCheck) {
            for (String methodName : this.pBaseClassMethods) {
                this.checkClassFunctions(rfClass, methodName);
            }
        }
        for (RfClass rfClass : noParrentClasses) {
            ParserPath path;
            if (this.pNoParentMethods.isEmpty()) {
                Set<HidInfo> calls;
                RfDefElement classDeclaration = rfClass.getDeclaration();
                if (classDeclaration == null || (calls = this.typeOverrideCalls.get(path = classDeclaration.getParserPath())) == null) continue;
                Iterator<HidInfo> iterator = calls.iterator();
                while (iterator.hasNext()) {
                    HidInfo call = iterator.next();
                    if (!call.getRfClass().equals(rfClass)) continue;
                    iterator.remove();
                }
                continue;
            }
            path = this.pNoParentMethods.iterator();
            while (path.hasNext()) {
                String methodName;
                methodName = (String)path.next();
                this.checkClassFunctions(rfClass, methodName);
            }
        }
        for (Map.Entry entry : this.typeOverrideCalls.entrySet()) {
            ParserPath path = (ParserPath)entry.getKey();
            Set hidInfos = (Set)entry.getValue();
            for (HidInfo hidInfo : hidInfos) {
                RfClass clazz = hidInfo.getRfClass();
                RfHid hid = hidInfo.getHid();
                this.addHit(path, hid, "Illegal '" + hid.getName() + "()' ocurrence in '" + clazz.getName() + "'.");
            }
        }
    }

    private void checkClassFunctions(final RfClass clazz, String methodName) {
        RfFunction allowedCallFunction = clazz.getFunctionWithPrefix(methodName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (allowedCallFunction == null) {
            allowedCallFunction = clazz.getConstructorWithPrefix(methodName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        if (allowedCallFunction == null) {
            allowedCallFunction = clazz.getTaskWithPrefix(methodName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        if (allowedCallFunction == null) {
            return;
        }
        this.notifyCheckAlive();
        allowedCallFunction.visitHidObject(this.fOVMProject.getRfProject(), new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                RfFunction tempFunction;
                Set<HidInfo> calls;
                if (Check_2_8_5.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                IRfNamedElement scope = ((HidHolder)this.holder).getScope();
                if (scope == null) {
                    return true;
                }
                RfClass classScope = (RfClass)scope.getEnclosingScope(RfClass.class);
                if (classScope == null) {
                    return true;
                }
                if (TYPE_OVERRIDE_FUNCTIONS.contains(element.getName()) && (calls = Check_2_8_5.this.typeOverrideCalls.get(this.parserPath)) != null) {
                    calls.remove(new HidInfo(hidObject, clazz));
                    return true;
                }
                if (!Check_2_8_5.this.pAllowIndirectCallOverrideValue) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                if (!classScope.equals(clazz) && !Check_2_8_5.this.fOVMProject.isOVMElement(function) && function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hidObject, clazz)) != null) {
                    function = tempFunction;
                }
                HashMap<String, Set<RfFunction>> visitedObjectFunctions = new HashMap<String, Set<RfFunction>>();
                HashSet<RfFunction> localFunction = new HashSet<RfFunction>();
                localFunction.add(function);
                visitedObjectFunctions.put(function.getFullName(), localFunction);
                RfClass methodCallScope = Check_2_8_5.this.getMethodCallScope(hidObject);
                if (methodCallScope == null) {
                    methodCallScope = clazz;
                }
                function.visitHidObject(null, new IndirectCallsVisitor(visitedObjectFunctions, methodCallScope));
                return true;
            }
        });
    }

    private RfClass getMethodCallScope(RfHid hidObject) {
        if (LintUtils.isSuper(hidObject)) {
            return null;
        }
        if (hidObject.getParentAccess() == null) {
            return null;
        }
        HidAccess parentAccess = hidObject.getParentAccess();
        if (parentAccess.getParentHid() == null) {
            return null;
        }
        Hid parentHid = parentAccess.getParentHid();
        if (!(parentHid instanceof RfHid)) {
            return null;
        }
        IRfNamedElement parentElement = parentHid.getElement();
        if (!(parentElement instanceof RfAssociatedType)) {
            return null;
        }
        RfNamedElement parentElementType = LintUtils.getAssociatedFinalType((RfAssociatedType)parentElement);
        if (parentElementType instanceof RfClass) {
            return (RfClass)parentElementType;
        }
        return null;
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static class HidInfo {
        private RfHid hid;
        private RfClass rfClass;

        public HidInfo(RfHid hid, RfClass rfClass) {
            this.hid = hid;
            this.rfClass = rfClass;
        }

        public RfClass getRfClass() {
            return this.rfClass;
        }

        public RfHid getHid() {
            return this.hid;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.hid == null ? 0 : this.hid.hashCode());
            result = 31 * result + (this.rfClass == null ? 0 : this.rfClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HidInfo)) {
                return false;
            }
            if (!this.rfClass.equals(((HidInfo)obj).getRfClass())) {
                return false;
            }
            if (!this.hid.equals((Object)((HidInfo)obj).getHid())) {
                return false;
            }
            return this.hid.getOccurrence().equals((Object)((HidInfo)obj).getHid().getOccurrence());
        }
    }

    private class IndirectCallsVisitor
    extends RfHidVisitor {
        private Map<String, Set<RfFunction>> visitedFunctions = new HashMap<String, Set<RfFunction>>();
        private RfClass functionClass;

        public IndirectCallsVisitor(Map<String, Set<RfFunction>> visitedFunctions, RfClass functionClass) {
            this.visitedFunctions = visitedFunctions;
            this.functionClass = functionClass;
        }

        public boolean visit(RfHid hidObject) {
            RfFunction tempFunction;
            if (Check_2_8_5.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            IRfNamedElement scope = ((HidHolder)this.holder).getScope();
            if (scope == null) {
                return true;
            }
            RfClass classScope = (RfClass)scope.getEnclosingScope(RfClass.class);
            if (classScope == null) {
                return true;
            }
            RfClass methodCallScope = Check_2_8_5.this.getMethodCallScope(hidObject);
            if (methodCallScope == null) {
                methodCallScope = this.functionClass;
            }
            RfFunction function = (RfFunction)element;
            if (!Check_2_8_5.this.fOVMProject.isOVMElement(function) && function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hidObject, methodCallScope)) != null) {
                function = tempFunction;
            }
            if (TYPE_OVERRIDE_FUNCTIONS.contains(element.getName())) {
                Set<HidInfo> calls = Check_2_8_5.this.typeOverrideCalls.get(this.parserPath);
                if (calls != null) {
                    calls.remove(new HidInfo(hidObject, classScope));
                }
                return true;
            }
            Set<RfFunction> localFunctions = this.visitedFunctions.get(function.getFullName());
            if (localFunctions != null && localFunctions.contains(function)) {
                return true;
            }
            if (localFunctions == null) {
                localFunctions = new HashSet<RfFunction>();
                localFunctions.add(function);
                this.visitedFunctions.put(function.getFullName(), localFunctions);
            } else {
                localFunctions.add(function);
            }
            function.visitHidObject(null, new IndirectCallsVisitor(this.visitedFunctions, methodCallScope));
            return true;
        }
    }
}

