/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="XVM.2.8.6")
@CheckName(value="XVM.2.8.6")
@CheckTitle(value="Encapsulate test sequences")
@CheckDescription(value="The run phase of a testcase should only be used to select and start the test sequence.\nThe run phase is not allowed to directly drive any interfaces.\nThis keeps all of the testcases encapsulated in reuseable sequences.\nThis allows the test sequence to be directly reused for additional tests or even vertically - in an environment that reuses ''this'' environment.\nDirected tests should be encapsulated as sequences. Directed tests defined within the test class run phase, while allowed, are strongly discouraged. Testcases cannot be reused - but sequences can.\n\nImplementation Notes:\nTestcases whose name ends with _dir_test are not checked.")
public class Check_2_8_6
extends OVMComplianceCheck {
    public Check_2_8_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(33);
        aRfProject.lintTrackP2LInfo(77);
    }

    @Override
    public void performCheckImpl() {
        String xvmRunPhaseMethodName = this.fOVMProject.getRunPhaseMethodName();
        if (this.fOVMProject.fOvmTest != null) {
            this.checkAssignmentIssues(this.fOVMProject.getSVTBIssuesWithKind(33), xvmRunPhaseMethodName);
            this.checkAssignmentIssues(this.fOVMProject.getSVTBIssuesWithKind(77), xvmRunPhaseMethodName);
        }
    }

    private void checkAssignmentIssues(Map<ParserPath, List<SVTBIssues>> issuesMap, String xvmRunPhaseMethodName) {
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : issuesMap.entrySet()) {
            List<SVTBIssues> issues;
            ParserPath parserPath = entry.getKey();
            RfFileDef filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
            if (filedef == null || (issues = entry.getValue()) == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            for (SVTBIssues issue : issues) {
                String leftValue;
                RfClass clazz;
                RfFunction function;
                RfNamedElement scope;
                RfDefElement defScope = filedef.getScope(issue.getOffset(), true);
                if (defScope == null || (scope = defScope.getNamedElement()) == null || (function = this.getClosestFunction(scope)) == null || function.getName() == null || !function.getName().equals(xvmRunPhaseMethodName) || (clazz = this.getClosestClass(scope)) == null || !clazz.isSubClass(this.fOVMProject.fOvmTest) || clazz.getName() == null || clazz.getName().endsWith("_dir_test") || (leftValue = issue.getInfo()) == null || !this.isInterfaceSignal(scope, issue.getOffset(), leftValue)) continue;
                this.addHit(parserPath, issue.getLine(), String.valueOf(xvmRunPhaseMethodName) + "() of testcase '" + clazz.getName() + "' drives '" + leftValue + "'" + "!", issue.getReparseInfo());
            }
        }
    }

    private boolean isInterfaceSignal(RfNamedElement scope, int offset, String text) {
        RfNamedElement container;
        String[] nameAndSelect = LintUtils.getNameAndSelect(text);
        String identifier = nameAndSelect[0];
        if (identifier == null) {
            return false;
        }
        RfNamedElement elem = LintUtils.getElementFromString(this.fOVMProject.getRfProject(), scope, offset, identifier);
        return elem != null && elem instanceof RfField && (container = elem.getClosestTypeContainer()) != null && container instanceof RfInterface;
    }

    private RfClass getClosestClass(RfNamedElement element) {
        RfNamedElement result = element;
        while (result != null) {
            if (result instanceof RfClass) {
                return (RfClass)result;
            }
            result = result.getEnclosingScope();
        }
        return null;
    }

    private RfFunction getClosestFunction(RfNamedElement element) {
        RfNamedElement result = element;
        while (result != null) {
            if (result instanceof RfFunction) {
                return (RfFunction)result;
            }
            result = result.getEnclosingScope();
        }
        return null;
    }
}

