/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="20.1.4")
@CheckID(value="XVM.2.8.9")
@CheckName(value="XVM.2.8.9")
@CheckLabel(labels={RuleLabel.OBJECTION, RuleLabel.TEST, RuleLabel.METHOD, RuleLabel.RUN_PHASE, RuleLabel.VERIFICATION})
@CheckTitle(value="Raise and drop objections in tests")
@CheckDescription(value="This rule checks that in tests there is at least one raise_objection() and one drop_objection() called from the run_phase() method.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_2_8_9
extends OVMComplianceCheck {
    RfClass xvmPhase;
    RfClass xvmObjection;
    private Queue<RfFunction> queuedFunctions;
    private Set<RfFunction> visitedFunctions;

    public Check_2_8_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass xvmTest;
        if (this.fOVMProject.getLibraryKind() == 2) {
            this.xvmPhase = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_phase", true);
            this.xvmObjection = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_objection", true);
            xvmTest = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_test", true);
        } else {
            this.xvmPhase = null;
            this.xvmObjection = this.fOVMProject.getRfProject().getClass("ovm_pkg::ovm_objection", true);
            xvmTest = this.fOVMProject.getRfProject().getClass("ovm_pkg::ovm_test", true);
        }
        if (this.xvmObjection == null) {
            return;
        }
        this.queuedFunctions = new LinkedList<RfFunction>();
        this.visitedFunctions = new HashSet<RfFunction>();
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            ParserPath classParserPath;
            RfFileDef classFile;
            if (!((RfClass)clazz).isSubClass(xvmTest) || (classFile = clazz.getFile()) == null || (classParserPath = classFile.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            this.notifyCheckAlive();
            List<RfFunction> runPhaseTasks = ((RfClass)clazz).getTasksWithPrefix(this.fOVMProject.getRunPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (runPhaseTasks == null || runPhaseTasks.isEmpty() || runPhaseTasks.size() != 1) continue;
            RfFunction runPhaseTask = runPhaseTasks.get(0);
            this.queuedFunctions.clear();
            this.visitedFunctions.clear();
            boolean raiseObjections = false;
            boolean dropObjections = false;
            RaiseAndDropObjectionsVisitor visitor = new RaiseAndDropObjectionsVisitor(clazz);
            this.queuedFunctions.add(runPhaseTask);
            while (!(this.queuedFunctions.isEmpty() || dropObjections && raiseObjections)) {
                RfFunction currentFunction = this.queuedFunctions.poll();
                if (this.visitedFunctions.contains(currentFunction)) continue;
                currentFunction.visitHidObject(null, visitor);
                this.visitedFunctions.add(currentFunction);
                dropObjections = visitor.getDropObjections();
                raiseObjections = visitor.getRaiseObjections();
            }
            if (!raiseObjections) {
                this.addHit(runPhaseTask, "Test run phase '" + runPhaseTask.getFullName() + "' does not call raise_objection() method!");
            }
            if (dropObjections) continue;
            this.addHit(runPhaseTask, "Test run phase '" + runPhaseTask.getFullName() + "' does not call drop_objection() method!");
        }
    }

    private class RaiseAndDropObjectionsVisitor
    extends RfHidVisitor {
        boolean raiseObjections = false;
        boolean dropObjections = false;
        private RfClass functionClass;

        public RaiseAndDropObjectionsVisitor(RfNamedElement clazz) {
            this.functionClass = (RfClass)clazz;
        }

        public boolean visit(RfHid hidObject) {
            boolean xvmPhaseFlag;
            if (this.raiseObjections && this.dropObjections) {
                return false;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            RfNamedElement enclosingScope = function.getEnclosingScope();
            if (!(enclosingScope instanceof RfClass)) {
                return true;
            }
            if (!Check_2_8_9.this.fOVMProject.isOVMElement(function)) {
                RfFunction tempFunction;
                if (function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hidObject, this.functionClass)) != null) {
                    function = tempFunction;
                }
                Check_2_8_9.this.queuedFunctions.add(function);
                return true;
            }
            if (!function.isFunction()) {
                return true;
            }
            boolean xvmObjectionFlag = !enclosingScope.equals(Check_2_8_9.this.xvmObjection) && !((RfClass)enclosingScope).isSubClass(Check_2_8_9.this.xvmObjection);
            boolean bl = xvmPhaseFlag = !enclosingScope.equals(Check_2_8_9.this.xvmPhase) && !((RfClass)enclosingScope).isSubClass(Check_2_8_9.this.xvmPhase);
            if (Check_2_8_9.this.xvmPhase != null && xvmPhaseFlag && xvmObjectionFlag) {
                return true;
            }
            if (Check_2_8_9.this.xvmPhase == null && xvmObjectionFlag) {
                return true;
            }
            if (function.getName().equals("raise_objection")) {
                this.raiseObjections = true;
                return true;
            }
            if (function.getName().equals("drop_objection")) {
                this.dropObjections = true;
                return true;
            }
            return true;
        }

        public boolean getRaiseObjections() {
            return this.raiseObjections;
        }

        public boolean getDropObjections() {
            return this.dropObjections;
        }
    }
}

