/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

@CheckVersion(value="17.1.24")
@CheckID(value="XVM.2.9.1.5.1")
@CheckName(value="XVM.2.9.1.5.1")
@CheckLabel(labels={RuleLabel.COVERAGE, RuleLabel.CLASS, RuleLabel.CONSTRUCTOR, RuleLabel.VERIFICATION})
@CheckTitle(value="Coverage Collector Class Constructor")
@CheckDescription(value="All covergroups defined in a coverage collector class must be instantiated in the constructor.\n\nCheck supports pre-waiving.")
public class Check_2_9_1_5_1
extends OVMComplianceCheck {
    public Check_2_9_1_5_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (final RfNamedElement covergroup : this.fOVMProject.getAllCovergroups()) {
            if (this.checkPreWaivers(covergroup.getFile()) || !(covergroup.getEnclosingScope() instanceof RfClass)) continue;
            this.notifyCheckAlive();
            RfClass classs = (RfClass)covergroup.getEnclosingScope();
            RfFunction constructor = classs.getConstructorWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
            final AtomicBoolean isCovergroupInstantiated = new AtomicBoolean(false);
            if (constructor != null && !(constructor instanceof RfPredefinedFunction)) {
                constructor.visitHidObject(null, new IHidVisitor<IHidObject>(){

                    public boolean visit(IHidObject hidObject) {
                        if (hidObject.getHidKind() == IHidObject.HidKind.HID) {
                            Hid hid = (Hid)hidObject;
                            IRfNamedElement iRfNamedElement = parentAccessType = hid.getParentAccess() == null ? null : hid.getParentAccess().getAssociatedType();
                            if (hid.getName().equals("new") && parentAccessType instanceof RfCovergroup var4_5 && hidCovergroup.getOriginal().equals(covergroup)) {
                                isCovergroupInstantiated.set(true);
                                return false;
                            }
                        }
                        return true;
                    }

                    public Class<IHidObject> getType() {
                        return IHidObject.class;
                    }
                });
            }
            if (isCovergroupInstantiated.get()) continue;
            this.addHit(covergroup, "Covergroup '" + LintUtils.getNamedElementFullName(covergroup) + "' not instantiated in the constructor of class '" + LintUtils.getNamedElementFullName(classs) + "'!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

