/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.4")
@CheckID(value="XVM.2.9.2.7")
@CheckName(value="XVM.2.9.2.7")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.TASK, RuleLabel.VIRTUAL_INTERFACE, RuleLabel.SCOREBOARD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare tasks and virtual interfaces in scoreboards")
@CheckDescription(value="A scoreboard should not depend on the testbench clock. Avoid tasks and virtual interfaces in scoreboards.\nCheck supports pre-waiving.")
public class Check_2_9_2_7
extends OVMComplianceCheck {
    public Check_2_9_2_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_scoreboard"), true);
        if (baseClass == null) {
            return;
        }
        for (RfNamedElement component : this.fOVMProject.getAllNonXVMClasses()) {
            ParserPath classParserPath;
            RfFileDef file;
            if (!(component instanceof RfClass) || !((RfClass)component).isSubClass(baseClass) || (file = component.getFile()) == null || (classParserPath = file.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(classParserPath, this)) continue;
            this.notifyCheckAlive();
            this.checkTaskAndInterfaceInScoreboard((RfClass)component);
        }
    }

    private void checkTaskAndInterfaceInScoreboard(RfClass component) {
        component.accept(null, new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (namedElement.isPredefined()) {
                    return true;
                }
                if (!(namedElement instanceof RfFunction) && !(namedElement instanceof RfField)) {
                    return true;
                }
                if (namedElement instanceof RfFunction) {
                    if (((RfFunction)namedElement).isTask()) {
                        Check_2_9_2_7.this.addHit(namedElement, "Task '" + namedElement.getFullName() + "' declared in scoreboard!");
                        return false;
                    }
                    return true;
                }
                RfField field = (RfField)namedElement;
                if (field.getDataType() != null && field.getDataType().isVirtualInterface()) {
                    Check_2_9_2_7.this.addHit(namedElement, "Virtual interface '" + namedElement.getFullName() + "' declared in scoreboard!");
                    return true;
                }
                return true;
            }
        });
    }
}

