/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.20")
@CheckID(value="XVM.2.9.2.8")
@CheckName(value="XVM.2.9.2.8")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.SEQUENCE_ITEM, RuleLabel.SCOREBOARD, RuleLabel.SUBSCRIBER, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not modify received sequence items in scoreboards and subscribers")
@CheckDescription(value="In scoreboards and subscribers, sequence items received via the write port should not be modified. For all scoreboards that have a 'write' method and all subscribers, this check flags the arguments of type sequence item that have their values modified.")
@CheckReapplyDisable
public class Check_2_9_2_8
extends OVMComplianceCheck {
    public Check_2_9_2_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<RfClass> allSubscribers;
        String lib = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "");
        RfClass scoreboardClass = this.fOVMProject.getRfProject().getClass(String.valueOf(lib) + "_pkg::" + lib + "_scoreboard", true);
        RfClass subscriberClass = this.fOVMProject.getRfProject().getClass(String.valueOf(lib) + "_pkg::" + lib + "_subscriber", true);
        RfClass sequenceItemClass = this.fOVMProject.getRfProject().getClass(String.valueOf(lib) + "_pkg::" + lib + "_sequence_item", true);
        if (scoreboardClass == null) {
            return;
        }
        if (subscriberClass == null) {
            return;
        }
        if (sequenceItemClass == null) {
            return;
        }
        Set<RfClass> allScoreboards = scoreboardClass.getChildren();
        if (allScoreboards != null) {
            for (RfClass rfClass : allScoreboards) {
                this.checkClass(rfClass, sequenceItemClass);
            }
        }
        if ((allSubscribers = subscriberClass.getChildren()) != null) {
            for (RfClass rfClass : allSubscribers) {
                this.checkClass(rfClass, sequenceItemClass);
            }
        }
    }

    public void checkClass(RfNamedElement element, RfClass sequenceItemClass) {
        if (!(element instanceof RfClass)) {
            return;
        }
        this.notifyCheckAlive();
        RfFunction function = ((RfClass)element).getLocalFunction("write");
        if (function == null) {
            return;
        }
        List<IRfFieldElement> arguments = function.getArguments();
        for (IRfNamedElement iRfNamedElement : arguments) {
            if (!this.isSequenceItem(iRfNamedElement, sequenceItemClass)) continue;
            RfNamedElement namedElement = (RfNamedElement)iRfNamedElement;
            function.visitHidObject(this.fOVMProject.getRfProject(), new FunctionCallVisitor(function, namedElement, new HashSet<RfFunction>()));
        }
    }

    public boolean isSequenceItem(IRfNamedElement element, RfClass sequenceItemClass) {
        if (!(element instanceof RfField)) {
            return false;
        }
        RfField field = (RfField)element;
        RfClass elementClass = LintUtils.getFieldFinalClassTypeOrNull(field);
        if (elementClass == null) {
            return false;
        }
        return LintUtils.isSubClassOf(elementClass, sequenceItemClass);
    }

    private final class AssignmentVisitor
    implements IHidVisitor<RfHidOperator> {
        private RfNamedElement namedElement;
        private boolean isChanged;
        private ParserPath parserPath;

        public AssignmentVisitor(RfNamedElement namedElement) {
            this.namedElement = namedElement;
            this.isChanged = false;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject.isAssignment()) {
                IHidObject lhValue = hidObject.getLHValue();
                if (lhValue instanceof RfHidAccess) {
                    RfHidAccess hidAccess = (RfHidAccess)lhValue;
                    lhValue = hidAccess.getParentHid();
                }
                if (this.checkParents(lhValue, this.namedElement)) {
                    Check_2_9_2_8.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Sequence item " + this.namedElement.getFullName() + " received via write port should not be modified!");
                    this.isChanged = true;
                    return true;
                }
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean checkParents(IHidObject hidObject, RfNamedElement namedElement) {
            if (hidObject == null) {
                return false;
            }
            if (hidObject instanceof RfHid && ((RfHid)hidObject).getAncestorHid() != null && ((RfHid)hidObject).getAncestorHid().getElement() != null && ((RfHid)hidObject).getAncestorHid().getElement().equals(namedElement)) {
                return true;
            }
            if (hidObject instanceof Hid) {
                if (((Hid)hidObject).getElement() == null) {
                    return false;
                }
                if (((Hid)hidObject).getElement().equals(namedElement)) {
                    return true;
                }
                return this.checkParents((IHidObject)((Hid)hidObject).getParentHid(), namedElement);
            }
            return false;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private final class FunctionCallVisitor
    implements IHidVisitor<RfHid> {
        private RfNamedElement namedElement;
        private RfFunction function;
        private Set<RfFunction> visitedFunctions;
        private AssignmentVisitor assignmentVisitor;

        public FunctionCallVisitor(RfFunction function, RfNamedElement namedElement, Set<RfFunction> visiSet) {
            this.function = function;
            this.namedElement = namedElement;
            this.visitedFunctions = visiSet;
            this.assignmentVisitor = new AssignmentVisitor(namedElement);
            function.visitHidObject(Check_2_9_2_8.this.fOVMProject.getRfProject(), this.assignmentVisitor);
        }

        public boolean visit(RfHid hidObject) {
            if (this.assignmentVisitor.isChanged) {
                return false;
            }
            if (hidObject.isMethodCall(false)) {
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                this.visitedFunctions.add(this.function);
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
                for (MethodCall methodCall : methodCalls) {
                    if (!methodCall.method.equals(element)) continue;
                    if (this.visitedFunctions.contains(methodCall.method)) {
                        return true;
                    }
                    Map argumentsMap = methodCall.argumentValuesMapRaw;
                    if (argumentsMap == null) continue;
                    for (Map.Entry entry : argumentsMap.entrySet()) {
                        IHidObject iHidObject = (IHidObject)entry.getValue();
                        if (!(iHidObject instanceof RfHid) || ((RfHid)iHidObject).getElement() == null || !((RfHid)iHidObject).getElement().equals(this.namedElement)) continue;
                        element.visitHidObject((IRfSingleLangProject)Check_2_9_2_8.this.fOVMProject.getRfProject(), (IHidVisitor)new FunctionCallVisitor((RfFunction)element, (RfNamedElement)entry.getKey(), this.visitedFunctions));
                    }
                }
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

