/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_Names;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractNameCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.1.1")
@CheckName(value="XVM.3.1.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.CLASS, RuleLabel.STYLING, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence Item Class Name")
@CheckDescription(value="The sequence item class name must end with the '_item' suffix.\n\nExamples for default suffix = '_item':\nclass my_seq_item extends uvm_sequence_item; endclass // allowed\nclass my_class extends uvm_sequence_item; endclass // not allowed\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_XVM_Names.class)
@CheckParameterOverride(name="suffix", defaultValue="_item", isVisible=true)
public class Check_3_1_1
extends AbstractNameCheck {
    public Check_3_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getHitMessage(RfNamedElement component, String suffixes) {
        return "Sequence item '" + component.getName() + "' must have one of the following suffixes: " + suffixes + "!";
    }

    @Override
    protected Map<String, RfClass> getComponents() {
        return this.fOVMProject.fSequenceItems;
    }
}

