/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="17.1.24")
@CheckID(value="XVM.3.1.10")
@CheckName(value="XVM.3.1.10")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.FIELD, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence item fields shall not be local or protected")
@CheckDescription(value="The fields of sequence item are accessed by other components like drivers and monitors but drivers and monitors are not derived from sequence items. So in order to have access to the fields of sequence items by other components, the fields must not be local or protected. Also on fields which are local or protected, procedure constraints cannot be applied as those fields are not visible outside the class.\n\nCheck supports pre-waiving.")
public class Check_3_1_10
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, skip fields which are assigned inside pre_randomize().", name="skipPrerandomizedFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipFieldsAssignedInPreRandomize;

    public Check_3_1_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> fSequenceItems = this.fOVMProject.fSequenceItems;
        if (fSequenceItems == null) {
            return;
        }
        for (RfClass item : fSequenceItems.values()) {
            List<RfField> fields;
            if (this.checkPreWaivers(item.getFile()) || (fields = item.getFields()) == null) continue;
            this.notifyCheckAlive();
            final HashSet<RfField> invalidFields = new HashSet<RfField>();
            for (RfField field : fields) {
                if (field.isPublic()) continue;
                invalidFields.add(field);
            }
            if (invalidFields.isEmpty()) continue;
            if (this.pSkipFieldsAssignedInPreRandomize) {
                RfFunction preRandomizeFunction = item.getFunctionWithPrefix("pre_randomize", 1, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
                if (preRandomizeFunction == null) continue;
                preRandomizeFunction.visitHidObject(this.fOVMProject.getRfProject(), new IHidVisitor<RfHidOperator>(){

                    public boolean visit(RfHidOperator hidOperator) {
                        if (!hidOperator.isAssignment()) {
                            return true;
                        }
                        IHidObject lhValue = hidOperator.getLHValue();
                        if (!(lhValue instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement element = ((RfHid)lhValue).getElement();
                        if (!(element instanceof RfField)) {
                            return true;
                        }
                        if (invalidFields.contains(element)) {
                            invalidFields.remove(element);
                        }
                        return true;
                    }

                    public Class<RfHidOperator> getType() {
                        return RfHidOperator.class;
                    }
                });
            }
            for (RfField field : invalidFields) {
                this.addHit(field, "Sequence item field '" + LintUtils.getNamedElementFullName(field) + "' is not public!");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

