/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsBeginEndMacroCheck;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.1.3")
@CheckName(value="XVM.3.1.3")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION, RuleLabel.REGISTRATION_MACRO, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Factory registration macros for sequence items")
@CheckDescription(value="The sequence item must register with the factory\nFor non-parameterized items:\n`xvm_object_utils(my_item)\nFor parameterized items:\n`xvm_object_param_utils(my_item#(my_params))\nRegistering with the factory is required for item creation and easy item overriding.")
@CheckParameterOverride(name="allowBeginEndMacros", defaultValue="true")
public class Check_3_1_3
extends AbstractUtilsBeginEndMacroCheck {
    public Check_3_1_3(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        HashSet<String> libObjectUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_utils") : Arrays.asList("`uvm_object_utils", "`uvm_object_abstract_utils"));
        HashSet<String> libObjectUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_utils_begin") : Arrays.asList("`uvm_object_utils_begin", "`uvm_object_abstract_utils_begin"));
        String libObjectUtilsEnd = isOVMLib ? "`ovm_object_utils_end" : "`uvm_object_utils_end";
        HashSet<String> libObjectParamUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_param_utils_begin") : Arrays.asList("`uvm_object_param_utils_begin", "`uvm_object_abstract_param_utils_begin"));
        HashSet<String> libObjectParamUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_param_utils") : Arrays.asList("`uvm_object_param_utils", "`uvm_object_abstract_param_utils"));
        this.checkMacros(this.fOVMProject.fSequenceItems, libObjectUtils, libObjectParamUtils, libObjectUtilsBegin, libObjectUtilsEnd, libObjectParamUtilsBegin, true, false);
    }
}

