/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractConstructorCheck;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.1.4.1")
@CheckName(value="XVM.3.1.4.1")
@CheckLabel(labels={RuleLabel.SEQUENCE_ITEM, RuleLabel.CONSTRUCTOR, RuleLabel.SEQUENCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence Item Constructor")
@CheckDescription(value="The constructor for a sequence item must look as follows (except the name default value):\n\nfunction new(string name = \"sequence item name\");\n  super.new(name);\nendfunction\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="allowCoverageInstantiation", isVisible=false)
public class Check_3_1_4_1
extends AbstractConstructorCheck {
    public Check_3_1_4_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        this.checkConstructor(this.fOVMProject.fSequenceItems, false, true);
    }
}

