/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractMembersCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.1.4.2.2")
@CheckName(value="XVM.3.1.4.2.2")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.FIELD, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Print must include all Members")
@CheckDescription(value="The do_print method must include all of the item member variables.\nFor all the fields in a sequence item the rule checks that there is a print method called on the printer argument of the enclosing do_print, with the field as argument for the compare method.\nWhen <checkRegisteredFields> is set to true, the check will flag the following fields: unregistered fields, fields registered with XVM_NOPRINT, fields registered without XVM_PRINT.\n\nExample:\ndo_print &= printer.print_field_int(\"field_name\", this.field_name, 32)")
public class Check_3_1_4_2_2
extends AbstractMembersCheck {
    public Check_3_1_4_2_2(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        for (RfClass seqItem : this.fOVMProject.fSequenceItems.values()) {
            AbstractMembersCheck.FieldsInfo info;
            List<RfField> fields;
            List<RfFunction> candidates = seqItem.getFunctionsWithPrefix("do_print", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidates == null || candidates.isEmpty() || (fields = seqItem.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || fields.isEmpty() || (info = this.getFieldsInfo(seqItem, fields, "do_print")) == null) continue;
            this.checkMembersInDoPrint(candidates.get(0), info.getFieldsToCheck(), info.getFieldsToFail(), this.pCheckRegisteredFields);
        }
    }
}

