/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractMembersCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.1.4.3.2")
@CheckName(value="XVM.3.1.4.3.2")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.FIELD, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Deep Copy must include all member variables")
@CheckDescription(value="The deep copy method must include all member variables. A missing member will lead to unnecessary of runtime debugging.\nStatic variables should not be included.\nIf a member variable is a class then all of their members (elements / fields) must be copied using either a call to clone (for a null handle) or copy (for a constructed instance.)\nWhen <checkRegisteredFields> is set to true, the check will flag the following fields: unregistered fields, fields registered with XVM_NOCOPY, fields registered without XVM_COPY.")
public class Check_3_1_4_3_2
extends AbstractMembersCheck {
    public Check_3_1_4_3_2(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        for (RfClass seqItem : this.fOVMProject.fSequenceItems.values()) {
            AbstractMembersCheck.FieldsInfo info;
            List<RfField> fields;
            List<RfFunction> candidates = seqItem.getFunctionsWithPrefix("do_copy", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidates == null || candidates.isEmpty() || (fields = seqItem.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || fields.isEmpty() || (info = this.getFieldsInfo(seqItem, fields, "do_copy")) == null) continue;
            this.checkMembersInDoCopy(candidates.get(0), info.getFieldsToCheck(), info.getFieldsToFail(), this.pCheckRegisteredFields);
        }
    }
}

