/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractMembersCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.1.4.4.2")
@CheckName(value="XVM.3.1.4.4.2")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Deep Compare Must include All Members")
@CheckDescription(value="The do_compare method must compare all of the item's member variables. A missing member from the deep compare call may lead to a false pass when the items are compared by the scoreboard.\nFor all the fields in a sequence item the rule checks that there is a compare method called on the comparer argument of the enclosing do_compare, with the field as argument for the compare method.\nWhen <checkRegisteredFields> is set to true, the check will flag the following fields: unregistered fields, fields registered with XVM_NOCOMPARE, fields registered without XVM_COMPARE.\n\nExample:\ndo_compare &= comparer.compare_field_int(\"field_name\", this.field_name, RHS.field_name, 32)")
public class Check_3_1_4_4_2
extends AbstractMembersCheck {
    public Check_3_1_4_4_2(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        for (RfClass seqItem : this.fOVMProject.fSequenceItems.values()) {
            AbstractMembersCheck.FieldsInfo info;
            List<RfField> fields;
            RfFunction do_compare_method = seqItem.getFunctionWithPrefix("do_compare", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (do_compare_method == null || (fields = seqItem.getLocalFields()) == null || fields.isEmpty() || (info = this.getFieldsInfo(seqItem, fields, "do_compare")) == null) continue;
            this.checkMembersInDoCompare(do_compare_method, info.getFieldsToCheck(), info.getFieldsToFail(), this.pCheckRegisteredFields);
        }
    }
}

