/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="20.1.8")
@CheckID(value="XVM.3.1.4.7")
@CheckName(value="XVM.3.1.4.7")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.TASK, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence tasks must be protected or local")
@CheckDescription(value="In all sequences (extensions of uvm_sequence) tasks must be protected or local.\nUsers should not call tasks on sequences to move simulation time forward.")
public class Check_3_1_4_7
extends OVMComplianceCheck {
    public Check_3_1_4_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String lib = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "");
        RfClass seqClass = this.fOVMProject.getRfProject().getClass(String.valueOf(lib) + "_pkg::" + lib + "_sequence", true);
        if (seqClass == null) {
            return;
        }
        Set<RfClass> children = seqClass.getChildren();
        if (children == null) {
            return;
        }
        HashSet<RfClass> visited = new HashSet<RfClass>();
        for (RfClass elem : children) {
            if (visited.contains(elem)) continue;
            visited.add(elem);
            this.checkAllChildren(elem, visited);
        }
    }

    public void checkAllChildren(RfClass elemClass, Set<RfClass> visited) {
        this.notifyCheckAlive();
        Set<RfClass> kids = elemClass.getChildren();
        this.checkTasksProtectedOrLocal(elemClass);
        if (kids != null && !kids.isEmpty()) {
            for (RfClass elem : kids) {
                if (visited.contains(elem)) continue;
                visited.add(elem);
                this.checkAllChildren(elem, visited);
            }
        }
    }

    public void checkTasksProtectedOrLocal(RfClass elemClass) {
        List<RfFunction> tasks = elemClass.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
        for (RfFunction task : tasks) {
            if (task.isParentVirtual()) continue;
            this.addHit(task, "Sequence task " + task.getName() + " in " + elemClass.getName() + " must be protected or local!");
        }
    }
}

