/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractCreatedInstanceNameCheck;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.1.9.1")
@CheckName(value="XVM.3.1.9.1")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.SEQUENCE_ITEM, RuleLabel.FIELD, RuleLabel.NAME, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="For all fields of a type extending from xvm_sequence_item, the constructed string name must match the field name")
@CheckDescription(value="The constructed string name (with either factory create or new) must exactly match the name of the class member that is being created, because XVM builds the hierarchy tree for instance overrides based on the provided string names.\n\nImplementation Notes:\nFor all new and create calls, if the created field is a XVM sequence item, perform the check.\nThe check is performed only if the field class type has a constructor with the first argument 'name'.\n\nExamples:\nm_myifc_item_h = myifc_item::type_id::create(\"m_myifc_item_h\", , this);\nNot allowed:\nm_myifc_item_h = myifc_item::type_id::create(\"myifc_seq\", , this);")
public class Check_3_1_9_1
extends AbstractCreatedInstanceNameCheck {
    @CheckParameter(defaultValue="rsp, req", description="Comma separated list of filed names for which the constructed string name doesn't have to match the field name.", name="skipFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipFields;
    @CheckParameter(defaultValue="false", description="When true, ignore assignments to hierarchical handles.", name="ignoreHierarchicalHandles", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pIgnoreHierarchicalHandles;

    public Check_3_1_9_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        this.checkCreatedInstanceNameInParentClasses(this.fOVMProject.fSequenceItems, null, this.pSkipFields, "sequence item", this.pIgnoreHierarchicalHandles, null, false);
    }
}

