/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.1.9.2")
@CheckName(value="XVM.3.1.9.2")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.FACTORY_CREATE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequences use ::create with get_full_name()")
@CheckDescription(value="Since a sequence is not a component, it cannot call create using \"this\". To match the implied hierarchy and allow instance based factory overrides, it needs to pass an explicit context to create.\nExample:\nm_myifc_item_h = my_ifc_item::type_id::create(\"m_myifc_item_h\", , get_full_name());\nm_myseq_h = myseq_seq::type_id::create(\"m_myseq_h\", , get_full_name());")
public class Check_3_1_9_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, only create calls of hierachical handles are checked.", name="checkOnlyHierarchicalHandles", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean checkOnlyHierarchicalHandles;
    private final String XVM_OBJECT_REGISTRY_CREATE;
    private final String XVM_COMPONENT_REGISTRY_CREATE;
    private Set<String> xvmCreateCalls;

    public Check_3_1_9_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.XVM_OBJECT_REGISTRY_CREATE = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_registry.create"));
        this.XVM_COMPONENT_REGISTRY_CREATE = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component_registry.create"));
        this.xvmCreateCalls = new HashSet<String>();
        this.xvmCreateCalls.add(this.XVM_COMPONENT_REGISTRY_CREATE);
        this.xvmCreateCalls.add(this.XVM_OBJECT_REGISTRY_CREATE);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences == null || this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        LocalCreateCallsVisitor visitor = new LocalCreateCallsVisitor();
        for (RfClass sequenceClass : this.fOVMProject.fSequences.values()) {
            this.notifyCheckAlive();
            if (this.fOVMProject.isOVMElement(sequenceClass)) continue;
            sequenceClass.visitHidObject(null, visitor);
        }
    }

    class LocalCreateCallsVisitor
    implements IHidVisitor<IHidObject> {
        RfNamedElement scope;
        ParserPath parserPath;

        LocalCreateCallsVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            RfField element;
            if (this.scope.isPredefined()) {
                return true;
            }
            if (!HidUtils.isOperator((IHidObject)hidObject)) {
                return true;
            }
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            if (lhValue instanceof RfHidImplicit && (element = this.scope.getLocalMember(RfField.class, ((RfHidImplicit)lhValue).getName(), true)) == null) {
                return true;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            IHidObject rightHid = (IHidObject)rhValues.get(0);
            MethodCall methodCall = null;
            if (rightHid instanceof RfHidAccessArgs) {
                methodCall = ((RfHidAccessArgs)rightHid).getMethodCall();
            } else if (rightHid instanceof RfHid) {
                IRfNamedElement element2 = ((RfHid)rightHid).getElement();
                if (!(element2 instanceof RfFunction)) {
                    return true;
                }
                methodCall = MethodCallUtils.getMethodCall((IHidObject)rightHid, (IRfNamedElement)element2, null, null, (boolean)false, null);
            }
            if (methodCall == null || methodCall.method == null) {
                return true;
            }
            if (!(methodCall.method instanceof RfFunction)) {
                return true;
            }
            RfFunction methodCallFunction = (RfFunction)methodCall.method;
            if (!Check_3_1_9_2.this.xvmCreateCalls.contains(methodCallFunction.getFullName())) {
                return true;
            }
            if (lhValue instanceof RfHid && Check_3_1_9_2.this.checkOnlyHierarchicalHandles && ((RfHid)lhValue).getParentAccess() == null) {
                return true;
            }
            if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
                Check_3_1_9_2.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "No parameters for create called from a sequence!");
                return true;
            }
            RfField contxtArgument = ((RfFunction)methodCall.method).getArgumentWithPrefix("contxt", 1);
            if (contxtArgument == null) {
                Check_3_1_9_2.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "No actual parameter for create called from a sequence!");
                return true;
            }
            IHidObject createContextArgumentHidObject = (IHidObject)methodCall.argumentValuesMapRaw.get(contxtArgument);
            IHid createContextArgumentHid = HidUtils.getHidFrom((IHidObject)createContextArgumentHidObject);
            if (createContextArgumentHid instanceof RfHid) {
                boolean isCreateCallWithGetFullName;
                RfHid createContextArgument = (RfHid)createContextArgumentHid;
                IRfNamedElement createContextArgumentElement = createContextArgument.getElement();
                boolean bl = isCreateCallWithGetFullName = createContextArgumentElement instanceof RfFunction && "get_full_name".equals(createContextArgument.getName());
                if (!isCreateCallWithGetFullName) {
                    Check_3_1_9_2.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Create called from a sequence doesn't use 'get_full_name()' as a contxt argument!");
                    return true;
                }
                if (lhValue instanceof RfHid) {
                    RfHid lhHid = (RfHid)lhValue;
                    Hid createParentHid = createContextArgument.getParentHid();
                    Hid fieldParentHid = lhHid.getParentHid();
                    if (createParentHid == null && fieldParentHid == null) {
                        return true;
                    }
                    if (createParentHid != null && createParentHid.equals((Object)fieldParentHid)) {
                        return true;
                    }
                    Check_3_1_9_2.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Create called from a sequence doesn't use 'get_full_name()' on the same hierarchical handles with the created field!");
                }
                return true;
            }
            Check_3_1_9_2.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Create called from a sequence doesn't use 'get_full_name()' as a contxt argument!");
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

