/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractAdditionalMembersExtendedItemCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.2.1.1")
@CheckName(value="XVM.3.2.1.1")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.SUPER, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Super Call in do_compare")
@CheckDescription(value="If derived sequence item has a do_compare method defined it must call the parent's compare method and add comparisons for the added members.\nExample:\nclass derived_sequence_item extends base_sequence_item;\n  ...\n  function bit do_compare(xvm_object rds, xvm_comparer comparer);\n    derived_sequence_item rhs_;\n    bit status;\n\n    status = 1;\n    // Super Call to Parent Compare Method\n    status &= super.do_compare(rhs, comparer);\n\n    status &= comparer.compare_field(\"m_newone\", m_newone, rhs_.m_newone, $bits(m_newone));\n    ...\n    return(status);\n  endfunction: do_compare\nendclass\nFor all the added fields in a sequence item the rule checks that there is a print method called on the printer argument of the enclosing do_print, with the field as argument for the compare method.\nWhen <checkRegisteredFields> is set to true, the check will flag the following fields: unregistered fields, fields registered with XVM_NOCOMPARE, fields registered without XVM_COMPARE.")
public class Check_3_2_1_1
extends AbstractAdditionalMembersExtendedItemCheck {
    public Check_3_2_1_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkMethodContentsInExtendedItemsWithAdditionalMembers("do_compare");
    }

    @Override
    protected void checkAdditionalMemberInMethod(RfFunction method, List<RfField> fieldsToCheck, List<RfField> fieldsToFail, boolean checkRegisteredFields) {
        this.checkMembersInDoCompare(method, fieldsToCheck, fieldsToFail, checkRegisteredFields);
    }
}

