/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractAdditionalMembersExtendedItemCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.2.2.1")
@CheckName(value="XVM.3.2.2.1")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.SUPER, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Super Call in do_copy")
@CheckDescription(value="If derived sequence item has a do_copy method defined it must call the parent's copy method and add assignments for the added members.\nExample:\nclass derived_sequence_item extends base_sequence_item;\n  ...\n  function void do_copy(xvm_object rhs);\n    derived_sequence_item rhs_;\n    // Super Call to Parent Copy Method\n    super.do_copy(rhs);\n\n    m_newone = rhs_.m_newone;\n    ...\n  endfunction: do_copy\nendclass\nWhen <checkRegisteredFields> is set to true, the check will flag the following fields: unregistered fields, fields registered with XVM_COPY, fields registered without XVM_COPY.")
public class Check_3_2_2_1
extends AbstractAdditionalMembersExtendedItemCheck {
    public Check_3_2_2_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkMethodContentsInExtendedItemsWithAdditionalMembers("do_copy");
    }

    @Override
    protected void checkAdditionalMemberInMethod(RfFunction method, List<RfField> fieldsToCheck, List<RfField> fieldsToFail, boolean checkRegisteredFields) {
        this.checkMembersInDoCopy(method, fieldsToCheck, fieldsToFail, checkRegisteredFields);
    }
}

