/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractAdditionalMembersExtendedItemCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.2.3.1")
@CheckName(value="XVM.3.2.3.1")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.SUPER, RuleLabel.METHOD, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Super Call in do_print")
@CheckDescription(value="If derived sequence item has a do_print method defined it must call the parent's do_print method and add prints for the added members.\nExample:\nclass derived_sequence_item extends base_sequence_item;\n  ...\n  function void do_print(xvm_printer printer);\n    // Super Call to Parent Print Method\n    super.do_print(printer);\n\n    printer.print_field(\"m_newone\", m_newone, $bits(m_newone));\n    ...\n  endfunction: do_print\nendclass\nFor all the added fields in a sequence item the rule checks that there is a print method called on the printer argument of the enclosing do_print, with the field as argument for the compare method.\nWhen <checkRegisteredFields> is set to true, the check will flag the following fields: unregistered fields, fields registered with XVM_NOPRINT, fields registered without XVM_PRINT.")
public class Check_3_2_3_1
extends AbstractAdditionalMembersExtendedItemCheck {
    public Check_3_2_3_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkMethodContentsInExtendedItemsWithAdditionalMembers("do_print");
    }

    @Override
    protected void checkAdditionalMemberInMethod(RfFunction method, List<RfField> fieldsToCheck, List<RfField> fieldsToFail, boolean checkRegisteredFields) {
        this.checkMembersInDoPrint(method, fieldsToCheck, fieldsToFail, checkRegisteredFields);
    }
}

