/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.LinkedHashMap;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_Names;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractNameCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.3.1")
@CheckName(value="XVM.3.3.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.UVM_SEQUENCE, RuleLabel.CLASS, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence Class Name")
@CheckDescription(value="The sequence class name must end with the '_seq' suffix.\n\nExamples for default suffix = '_seq':\nclass my_seq extends uvm_sequence endclass // allowed\nclass my_class extends uvm_sequence; endclass // not allowed\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_XVM_Names.class)
@CheckParameterOverride(name="suffix", defaultValue="_seq, _vseq", isVisible=true)
public class Check_3_3_1
extends AbstractNameCheck {
    public Check_3_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getHitMessage(RfNamedElement component, String suffixes) {
        return "Sequence '" + component.getName() + "' must have one of the following suffixes: " + suffixes + "!";
    }

    @Override
    protected Map<String, RfClass> getComponents() {
        Map<String, RfClass> sequences = this.fOVMProject.fSequences;
        LinkedHashMap<String, RfClass> result = new LinkedHashMap<String, RfClass>();
        for (RfClass clazz : sequences.values()) {
            if (this.fOVMProject.isOVMElement(clazz)) continue;
            result.put(clazz.getFullName(), clazz);
        }
        return result;
    }
}

