/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractCreateVsNewCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.3.11")
@CheckName(value="XVM.3.3.11")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.FACTORY_CREATE, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequences shall not be constructed directly")
@CheckDescription(value="Sequences must be created using the factory and not directly constructed with new. This allows a sequence to be replaced using the factory override methods.\nExample:\nNot allowed:\nmy_ifc_seq m_my_ifc_seq_h = new();\nAllowed:\nmy_ifc_seq m_my_ifc_seq_h;\n...\nm_my_ifc_seq_h = my_ifc_seq::type_id::create(\"m_my_ifc_seq_h\", this);\n\nCheck supports pre-waiving.")
public class Check_3_3_11
extends AbstractCreateVsNewCheck {
    public Check_3_3_11(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        this.checkCreateVersusNew();
    }

    @Override
    protected boolean checkType(RfClass createdType) {
        if (createdType == null) {
            return false;
        }
        this.notifyCheckAlive();
        return this.fOVMProject.fSequences.containsKey(createdType.getFullName());
    }
}

