/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractCreatedInstanceNameCheck;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.3.11.1")
@CheckName(value="XVM.3.3.11.1")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.FIELD, RuleLabel.NAME, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="For all fields of a type extending from xvm_sequence, the constructed string name must match the field name")
@CheckDescription(value="The constructed string name (with either factory create or new) must exactly match the name of the class member that is being created, because XVM builds the hierarchy tree for instance overrides based on the provided string names.\n\nImplementation Notes:\nFor all new and create calls, if the created field is a XVM sequence, perform the check.\nThe check is performed only if the field class type has a constructor with the first argument 'name'.\nWhen suffixPattern is specified and the additional suffix of the constructed string name contains format specifiers (eg: %d, %s etc), the check will replace only those which have explicit values in the list of arguments.\nIn order to match the rest, the user must specify in the suffixPattern the same format specifiers as in the string name construction.\n\nExamples:\nm_my_ifc_seq_h = new(\"m_my_ifc_seq_h\", this);\nm_my_ifc_seq_h = my_ifc_seq::type_id::create(\"m_my_ifc_seq_h\", this);\nm_my_ifc_seq_h[ndx] = my_ifc_seq::type_id::create($psprintf(\"m_my_ifc_seq_h[%0d]\",ndx), this);\nm_my_ifc_seq_h[e_ndx] = my_ifc_seq::type_id::create($psprintf(\"m_my_ifc_seq_h[%s]\",e_ndx.name()),this);\n//IFF allowConcatenation = true\nm_my_ifc_seq_h = my_ifc_seq::type_id::create({\"m_my_ifc\", \"_seq_h\"}, this);\n//IFF suffixPattern = _suffix_%0d or suffixPattern = _[a-z]+_%0d\nm_my_ifc_seq_h = my_ifc_seq::type_id::create($sformatf(\"m_my_ifc_seq_h_%s_%0d\", \"suffix\", i), ,this.get_full_name());\nm_my_ifc_seq_h[ndx] = my_ifc_seq::type_id::create($sformatf(\"m_my_ifc_seq_h_%s_%0d[%0d]\", \"suffix\", i, ndx), ,this.get_full_name());\nNot allowed:\nm_my_ifc_seq_h = new(\"my_ifc_seq\", this);\nm_my_ifc_seq_h = my_ifc_seq::type_id::create(\"my_ifc_seq\", this);\nm_my_ifc_seq_h = my_ifc_seq::type_id::create($sformatf(\"%s\", \"m_my_ifc_seq_h\"), this);\n\nCheck supports pre-waiving.")
public class Check_3_3_11_1
extends AbstractCreatedInstanceNameCheck {
    @CheckParameter(defaultValue="false", description="When true, ignore assignments to hierarchical handles.", name="ignoreHierarchicalHandles", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pIgnoreHierarchicalHandles;
    @CheckParameter(defaultValue="", description="Define the pattern of the additional suffix of the constructed string name.", name="suffixPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    protected Pattern pSuffixPattern;
    @CheckParameter(defaultValue="false", description="When true, allow string concatenation for the constructed string name.", name="allowConcatenation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowConcatenation;

    public Check_3_3_11_1(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        this.checkCreatedInstanceNameInParentClasses(this.fOVMProject.fSequences, null, null, "sequence", this.pIgnoreHierarchicalHandles, this.pSuffixPattern, this.pAllowConcatenation);
    }
}

