/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.3.4.2")
@CheckName(value="XVM.3.3.4.2")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Implement body - Main Sequence Method")
@CheckDescription(value="The body method defines the sequence, hence it must be implemented.\nIt is not required for virtual classes.\n\nCheck supports pre-waiving.")
public class Check_3_3_4_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="Allow sequence classes to inherit the body() method.", name="allowInheritance", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowInheritanceValue;
    @CheckParameter(defaultValue="uvm_pkg::uvm_sequence", description="Comma separated list of classes. It is legal to inherit body() up to this set of classes.", name="searchInheritanceUpToClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSearchInheritanceUpToClassesValue;

    public Check_3_3_4_2(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        for (RfClass sequenceClass : this.fOVMProject.fSequences.values()) {
            if (sequenceClass == null || this.fOVMProject.isOVMElement(sequenceClass) || sequenceClass.hasVirtualQualifier()) continue;
            searchInClass = sequenceClass;
            bodyFunction = null;
            this.notifyCheckAlive();
            if (!this.checkPreWaivers(sequenceClass.getFile())) ** GOTO lbl20
            continue;
            while (!this.pSearchInheritanceUpToClassesValue.contains(searchInClass.getFullName())) {
                candidates = searchInClass.getFunctionsWithPrefix("body", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (candidates == null || candidates.isEmpty()) {
                    candidates = searchInClass.getTasksWithPrefix("body", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                }
                if (candidates == null || candidates.isEmpty()) {
                    if (!this.pAllowInheritanceValue) break;
                    searchInClass = searchInClass.getParent();
                } else {
                    bodyFunction = candidates.get(0);
                    break;
                }
lbl20:
                // 2 sources

                if (searchInClass != null) continue;
            }
            if (bodyFunction != null) {
                this.addPassedHit(bodyFunction, String.valueOf(bodyFunction.getFullName()) + "() found for " + sequenceClass.getFullName());
                continue;
            }
            this.addHit(sequenceClass, String.valueOf(sequenceClass.getFullName()) + ".body() method not found!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

