/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.parser.TimeConsumingStatement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.3.4.2.2")
@CheckName(value="XVM.3.3.4.2.2")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.DELAY, RuleLabel.WAIT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not consume time between start_item() and finish_item()")
@CheckDescription(value="In a sequence body() no time can pass between the start_item() and finish_item() calls.\nDelays, waits or tasks cannot be used between start_item() and finish_item().\n\nImplementation Notes:\nThe rand_mode and constraint_mode tasks are ignored as they don't consume time.\n\nCheck supports pre-waiving.")
public class Check_3_3_4_2_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="Allow system task calls.", name="allowSystemTasks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowSystemTasksValue;

    public Check_3_3_4_2_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        for (RfClass sequence : this.fOVMProject.fSequences.values()) {
            RfFunction bodyTask;
            if (this.checkPreWaivers(sequence.getFile()) || this.fOVMProject.isOVMElement(sequence) || (bodyTask = sequence.getLocalTask("body")) == null) continue;
            this.notifyCheckAlive();
            List<RfFunctionCall> functionCalls = bodyTask.getFunctionCallsWithPrefix("", 2);
            Collections.sort(functionCalls, new Comparator<RfFunctionCall>(){

                @Override
                public int compare(RfFunctionCall o1, RfFunctionCall o2) {
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1 == o2) {
                        return 0;
                    }
                    return Integer.valueOf(o1.getLine()).compareTo(o2.getLine());
                }
            });
            boolean allPairsMatch = true;
            LinkedList<LinePair> linePairs = new LinkedList<LinePair>();
            RfFunctionCall startItemCall = null;
            int i = 0;
            while (i < functionCalls.size()) {
                if (functionCalls.get(i).getName().equals("start_item")) {
                    if (startItemCall != null) {
                        allPairsMatch = false;
                        break;
                    }
                    startItemCall = functionCalls.get(i);
                } else if (functionCalls.get(i).getName().equals("finish_item")) {
                    if (startItemCall != null) {
                        linePairs.add(new LinePair(startItemCall.getLine(), functionCalls.get(i).getLine()));
                        startItemCall = null;
                    } else {
                        allPairsMatch = false;
                        break;
                    }
                }
                ++i;
            }
            if (startItemCall != null) {
                allPairsMatch = false;
            }
            if (!allPairsMatch) {
                this.addHit(bodyTask, "start_item() and finish_item() calls don't match");
                continue;
            }
            if (linePairs.isEmpty()) continue;
            List<TimeConsumingStatement> timeConsumingStatements = bodyTask.getTimeConsumingStatements();
            if (timeConsumingStatements != null) {
                for (TimeConsumingStatement timeConsumingStatement : timeConsumingStatements) {
                    for (LinePair linePair : linePairs) {
                        if (!linePair.contains(timeConsumingStatement.getLine())) continue;
                        this.addHit(timeConsumingStatement.getParserPath(), timeConsumingStatement.getLine(), "Time consuming statement found between start_intem() and finish_item()!", null);
                    }
                }
            }
            for (RfFunctionCall functionCall : functionCalls) {
                RfFunction method = functionCall.getFunction();
                for (LinePair linePair : linePairs) {
                    if (method == null || !method.isTask() || !linePair.contains(functionCall.getLine()) || this.pAllowSystemTasksValue && functionCall.getFunctionName().startsWith("$") || method instanceof RfPredefinedFunction && (method.getName().equals("rand_mode") || method.getName().equals("constraint_mode"))) continue;
                    this.addHit(functionCall, "Task found between start_intem() and finish_item()!");
                }
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private static class LinePair {
        private final int fStart;
        private final int fEnd;

        public LinePair(int start, int end) {
            this.fStart = start;
            this.fEnd = end;
        }

        public boolean contains(int line) {
            return this.fStart < line && this.fEnd > line;
        }
    }
}

