/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.3.7")
@CheckName(value="XVM.3.3.7")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.BANNED_API, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Disallowed Methods")
@CheckDescription(value="The following methods are specifically not allowed and shall not be utilized or overridden: post_body(), get_current_item().\n\nCheck supports pre-waiving.")
public class Check_3_3_7
extends OVMComplianceCheck {
    private static final String[] ILLEGAL_FUNCTION_CALLS = new String[]{"post_body", "get_current_item", "start_default_sequence", "get_num_reqs_sent", "get_num_rsps_received", "set_num_last_reqs", "get_num_last_reqs", "last_req", "set_num_last_rsps", "get_num_last_rsps", "last_rsp", "execute_item", "lock"};

    public Check_3_3_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> sequences = this.fOVMProject.fSequences;
        for (RfClass sequence : sequences.values()) {
            if (sequence == null || this.fOVMProject.isOVMElement(sequence) || this.checkPreWaivers(sequence.getFile())) continue;
            ArrayList<RfFunction> functions = new ArrayList<RfFunction>();
            List<RfFunction> localFunctionsAndTasks = sequence.getLocalMembers(RfFunction.class);
            if (localFunctionsAndTasks != null) {
                functions.addAll(localFunctionsAndTasks);
            }
            boolean isFailure = false;
            this.notifyCheckAlive();
            for (RfFunction function : functions) {
                if (function == null) continue;
                String[] stringArray = ILLEGAL_FUNCTION_CALLS;
                int n = ILLEGAL_FUNCTION_CALLS.length;
                int n2 = 0;
                while (n2 < n) {
                    String illegalFunction = stringArray[n2];
                    if (function.getName().equals(illegalFunction)) {
                        this.addHit(function, "'" + illegalFunction + "()' is overridden in '" + sequence.getName() + "'");
                        isFailure = true;
                    }
                    List<RfFunctionCall> allFunctionCalls = function.getFunctionCallsWithPrefix("", 2);
                    NullProtectedList<RfFunctionCall> illegalFunctionCalls = new NullProtectedList<RfFunctionCall>();
                    for (RfFunctionCall functionCall : allFunctionCalls) {
                        if (!functionCall.getName().matches(String.valueOf(illegalFunction) + "|.+\\." + illegalFunction)) continue;
                        illegalFunctionCalls.add(functionCall);
                    }
                    for (RfFunctionCall illegalFunctionCall : illegalFunctionCalls) {
                        this.addHit(illegalFunctionCall, "'" + illegalFunctionCall.getName() + "()' is used in '" + sequence.getName() + "'");
                        isFailure = true;
                    }
                    ++n2;
                }
            }
            if (isFailure) continue;
            this.addPassedHit(sequence, "No illegal function used or overridden in '" + sequence.getName() + "' sequence.");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

