/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractLayeredSequenceCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

@CheckVersion(value="3.1")
@CheckID(value="XVM.3.4.2")
@CheckName(value="XVM.3.4.2")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Start must reference this sequence")
@CheckDescription(value="When a layered sequence starts a lower (child) sequence, it must include the ''this'' handle of the sequencer along with the handle of the sequencer that will run the child sequence.\nThe start method call on a child sequence looks like this:\n   my_child_seq_h.start( m_sequencer, this);\n\nExample:\n task body();\n    qrst_basic_seq rst_basic_seq_h;\n    ...\n    rst_basic_seq_h = qrst_basic_seq::type_id::create(\"rst_basic_seq_h\");\n    ...\n   // apply reset - start child reset sequence\n   rst_basic_seq_h.start( m_sequencer, this);\n   ...\n endtask : body\n\nCheck supports pre-waiving.")
public class Check_3_4_2
extends AbstractLayeredSequenceCheck {
    public Check_3_4_2(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void visitStartMethodCall(Hid calledFunction, RfHid rfHid, ParserPath parserPath, IRfNamedElement parentElement, RfClass baseSequencerClass) {
        List methodCalls = MethodCallUtils.getMethodCalls((IHid)calledFunction);
        for (MethodCall methodCall : methodCalls) {
            Map argVals = methodCall.argumentValuesMapRaw;
            if (argVals.keySet().size() < 2) {
                this.addHit(parserPath, rfHid, "Start call on child sequence '" + parentElement.getName() + "' doesn't pass 'this' as a second argument!");
                continue;
            }
            for (Map.Entry entry : argVals.entrySet()) {
                IHidObject secondArgumentValue;
                IRfNamedElement resolvedSecondArgument;
                IRfNamedElement argument = (IRfNamedElement)entry.getKey();
                if ("sequencer".equals(argument.getName())) {
                    IHidObject firstArgumentValue = (IHidObject)entry.getValue();
                    if (firstArgumentValue instanceof RfHidAccess) {
                        IRfNamedElement associatedType = ((RfHidAccess)firstArgumentValue).getAssociatedType();
                        if (associatedType instanceof RfAssociatedType) {
                            associatedType = LintUtils.getAssociatedFinalType((RfAssociatedType)associatedType);
                        }
                        if (associatedType instanceof RfClass && LintUtils.isSubClassOf((RfClass)associatedType, baseSequencerClass)) continue;
                        this.addHit(parserPath, rfHid, "Start call on child sequence '" + parentElement.getName() + "' doesn't pass a sequencer as the first argument!");
                        continue;
                    }
                    IRfNamedElement resolvedFirstArgument = HidUtils.getResolvedElement((IHidObject)firstArgumentValue);
                    if (!(resolvedFirstArgument instanceof RfField) || !this.isSubclassOf((RfField)resolvedFirstArgument, baseSequencerClass)) {
                        this.addHit(parserPath, rfHid, "Start call on child sequence '" + parentElement.getName() + "' doesn't pass a sequencer as the first argument!");
                        continue;
                    }
                }
                if (!"parent_sequence".equals(argument.getName()) || (resolvedSecondArgument = HidUtils.getResolvedElement((IHidObject)(secondArgumentValue = (IHidObject)entry.getValue()))) == null || resolvedSecondArgument instanceof RfThisImplicitVariable) continue;
                this.addHit(parserPath, rfHid, "Start call on child sequence '" + parentElement.getName() + "' doesn't pass 'this' as a second argument!");
            }
        }
    }
}

