/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractLayeredSequenceCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="20.1.27")
@CheckID(value="XVM.3.4.3")
@CheckName(value="XVM.3.4.3")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence start method arguments")
@CheckDescription(value="The first argument of the sequence start method must be one of the following: \n - 'm_sequencer' field\n - 'get_sequencer()' method call\n - using the 'p_sequencer'(declared using the xvm_declare_p_sequencer) typed sequencer to access a member\n\nCheck supports pre-waiving.")
public class Check_3_4_3
extends AbstractLayeredSequenceCheck {
    public Check_3_4_3(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void visitStartMethodCall(Hid calledFunction, RfHid rfHid, ParserPath parserPath, IRfNamedElement parentElement, RfClass baseSequencerClass) {
        List methodCalls = MethodCallUtils.getMethodCalls((IHid)calledFunction);
        for (MethodCall methodCall : methodCalls) {
            Map argVals = methodCall.argumentValuesMapRaw;
            for (Map.Entry entry : argVals.entrySet()) {
                if (!"sequencer".equals(((IRfFieldElement)entry.getKey()).getName())) continue;
                IHidObject firstArgumentValue = (IHidObject)entry.getValue();
                AbstractLayeredSequenceCheck.Pair wraperTask = this.inWrapedTask(parserPath, methodCall.getOccurrence().getOffset(), firstArgumentValue);
                this.checkCorrectCall(firstArgumentValue, baseSequencerClass, wraperTask, parserPath, rfHid, false);
                return;
            }
        }
    }

    public AbstractLayeredSequenceCheck.Pair inWrapedTask(ParserPath parserPath, int offset, IHidObject firstArgumentValue) {
        RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return null;
        }
        RfDefElement scope = fileDef.getScope(offset, true);
        if (scope == null) {
            return null;
        }
        RfNamedElement element = scope.getNamedElement();
        if (element != null && element instanceof RfFunction) {
            List<IRfFieldElement> allArguments = ((RfFunction)element).getArguments();
            if (allArguments == null || allArguments.isEmpty()) {
                return null;
            }
            if (!(firstArgumentValue instanceof RfHid)) {
                return null;
            }
            IRfNamedElement argument = ((RfHid)firstArgumentValue).getElement();
            if (allArguments.contains(argument)) {
                return new AbstractLayeredSequenceCheck.Pair(element, argument);
            }
        }
        return null;
    }
}

