/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractDeclaredClassElementsCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="18.1.32")
@CheckID(value="XVM.3.5")
@CheckName(value="XVM.3.5")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.TASK, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare tasks in sequence items")
@CheckDescription(value="Do not declare tasks sequence items.\n\nCheck supports pre-waiving.")
public class Check_3_5
extends AbstractDeclaredClassElementsCheck {
    public Check_3_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<String, RfClass> allSequenceItems = this.fOVMProject.fSequenceItems;
        if (allSequenceItems == null || allSequenceItems.isEmpty()) {
            return;
        }
        HashSet<RfClass> baseClasses = new HashSet<RfClass>();
        baseClasses.addAll(allSequenceItems.values());
        HashSet<String> elementKind = new HashSet<String>();
        elementKind.add("task");
        this.performCheck(baseClasses, null, elementKind);
    }

    @Override
    public String getHitMessage(RfNamedElement namedElement, RfNamedElement enclosingClass) {
        return "Task '" + namedElement.getName() + "' declared inside sequence item class '" + enclosingClass.getName() + "'!";
    }

    @Override
    public void getCoverGroupInstantiation(RfClass clazz) {
    }

    @Override
    public boolean checkInnerClasses(RfNamedElement clazz, RfNamedElement enclosingScope) {
        return enclosingScope instanceof RfClass && !enclosingScope.equals(clazz);
    }
}

