/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.flowgraph.ExecutionFlowGraph;
import ro.amiq.vlogdt.linter.flowgraph.FlowNode;
import ro.amiq.vlogdt.linter.flowgraph.MethodFlowNode;
import ro.amiq.vlogdt.linter.flowgraph.OperatorFlowNode;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="18.1.33")
@CheckID(value="XVM.3.6")
@CheckName(value="XVM.3.6")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.RANDOMIZATION, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Randomize sequence before starting it")
@CheckDescription(value="xvm_sequence.randomize() must be called before xvm_sequence.start().\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_3_6
extends OVMComplianceCheck {
    private static final String RANDOMIZE = "randomize";
    private static final String START = "start";
    private static final String UVM_SEQUENCE = "uvm_sequence";
    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> randomizeCallsMap;
    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> startCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();

    public Check_3_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.randomizeCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
    }

    @Override
    public void performCheckImpl() {
        this.startCallsMap.clear();
        this.randomizeCallsMap.clear();
        this.getAllStartAndRandomizeHids();
        if (this.startCallsMap.isEmpty()) {
            return;
        }
        Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> validStartHids = this.getAllValidStartHids();
        Set<RfHidAccess> startedSequences = this.startCallsMap.keySet();
        for (RfHidAccess sequence : startedSequences) {
            if (sequence.getParentHid() == null) continue;
            String sequenceName = sequence.getParentHid().getName();
            if ("this".equals(sequenceName)) {
                sequenceName = sequence.getAssociatedType() != null ? sequence.getAssociatedType().getName() : "";
            }
            String sequenceType = sequence.getAssociatedType() instanceof RfNamedElement ? LintUtils.getNamedElementFullName((RfNamedElement)sequence.getAssociatedType()) : "";
            Map<RfNamedElement, Set<HidOccurrence>> startCalls = this.startCallsMap.get((Object)sequence);
            if (startCalls == null || startCalls.isEmpty()) continue;
            this.notifyCheckAlive();
            Set<RfNamedElement> startCallsScopes = startCalls.keySet();
            if (startCallsScopes == null || startCallsScopes.isEmpty()) continue;
            for (RfNamedElement scope : startCallsScopes) {
                Set<HidOccurrence> validOccurrences = validStartHids.get((Object)sequence) != null ? validStartHids.get((Object)sequence).get(scope) : null;
                Collection occurrencesInScope = startCalls.get(scope);
                if (occurrencesInScope == null) continue;
                for (HidOccurrence occurrence : occurrencesInScope) {
                    if (validOccurrences != null && validOccurrences.contains(occurrence)) continue;
                    this.addHit(scope.getDeclaration().getParserPath(), occurrence, "Sequence '" + sequenceName + "' of type '" + sequenceType + "' is not randomized before start!");
                }
            }
        }
    }

    private void getAllStartAndRandomizeHids() {
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (Check_3_6.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                HidAccess parentAccess = hidObject.getParentAccess();
                if (!(parentAccess instanceof RfHidAccess) || parentAccess.getAssociatedType() == null) {
                    return true;
                }
                IRfNamedElement parentType = parentAccess.getAssociatedType();
                if (!(parentType instanceof RfClass)) {
                    return true;
                }
                boolean isSequence = ((RfClass)parentType).isSubClass(Check_3_6.UVM_SEQUENCE, true);
                if (!isSequence) {
                    return true;
                }
                Check_3_6.this.notifyCheckAlive();
                if (!(this.holder instanceof RfHidHolder)) {
                    return true;
                }
                IRfNamedElement scope = ((RfHidHolder)this.holder).getScope();
                if (!(scope instanceof RfNamedElement)) {
                    return true;
                }
                if (!(parentAccess instanceof RfHidAccess)) {
                    return true;
                }
                RfHidAccess hidAccess = (RfHidAccess)parentAccess;
                if (Check_3_6.START.equals(hidObject.getName())) {
                    Map<RfNamedElement, Set<HidOccurrence>> map;
                    Set<HidOccurrence> startCallOccurrencesInScope;
                    if (!Check_3_6.this.startCallsMap.containsKey((Object)hidAccess)) {
                        Check_3_6.this.startCallsMap.put(hidAccess, new HashMap());
                    }
                    if ((startCallOccurrencesInScope = (map = Check_3_6.this.startCallsMap.get((Object)hidAccess)).get(scope)) == null) {
                        startCallOccurrencesInScope = new LinkedHashSet<HidOccurrence>();
                        map.put((RfNamedElement)scope, startCallOccurrencesInScope);
                    }
                    startCallOccurrencesInScope.add(hidObject.getOccurrence());
                } else if (Check_3_6.RANDOMIZE.equals(hidObject.getName())) {
                    Map<RfNamedElement, Set<HidOccurrence>> map;
                    Set<HidOccurrence> randomizeCallOccurrencesInScope;
                    if (!Check_3_6.this.randomizeCallsMap.containsKey((Object)hidAccess)) {
                        Check_3_6.this.randomizeCallsMap.put(hidAccess, new HashMap());
                    }
                    if ((randomizeCallOccurrencesInScope = (map = Check_3_6.this.randomizeCallsMap.get((Object)hidAccess)).get(scope)) == null) {
                        randomizeCallOccurrencesInScope = new LinkedHashSet<HidOccurrence>();
                        map.put((RfNamedElement)scope, randomizeCallOccurrencesInScope);
                    }
                    randomizeCallOccurrencesInScope.add(hidObject.getOccurrence());
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), visitor);
    }

    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> getAllValidStartHids() {
        HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> validStartHids = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
        Set<RfHidAccess> sequencesStarted = this.startCallsMap.keySet();
        for (RfHidAccess sequence : sequencesStarted) {
            Hid sequenceHid = sequence.getParentHid();
            Map<RfNamedElement, Set<HidOccurrence>> randomizeCalls = this.randomizeCallsMap.get((Object)sequence);
            Map<RfNamedElement, Set<HidOccurrence>> startCalls = this.startCallsMap.get((Object)sequence);
            if (startCalls == null || startCalls.isEmpty() || randomizeCalls == null || randomizeCalls.isEmpty()) continue;
            Set<RfNamedElement> randomizeCallsScopes = randomizeCalls.keySet();
            Set<RfNamedElement> startCallsScopes = startCalls.keySet();
            if (startCallsScopes == null || startCallsScopes.isEmpty() || randomizeCallsScopes == null || randomizeCallsScopes.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfNamedElement scope : startCallsScopes) {
                Collection startOccurences = startCalls.get(scope);
                if (startOccurences == null || startOccurences.isEmpty()) continue;
                RfNamedElement startCallContainer = scope;
                ArrayList<RfNamedElement> enclosingStartScopes = new ArrayList<RfNamedElement>();
                while (startCallContainer != null) {
                    if (startCallContainer instanceof RfFunction) {
                        enclosingStartScopes.add(startCallContainer);
                        break;
                    }
                    enclosingStartScopes.add(startCallContainer);
                    startCallContainer = startCallContainer.getEnclosingScope();
                }
                if (!(startCallContainer instanceof RfFunction)) continue;
                Collections.reverse(enclosingStartScopes);
                Iterator<RfNamedElement> iterator = randomizeCallsScopes.iterator();
                while (iterator.hasNext()) {
                    RfNamedElement callScope;
                    RfNamedElement randomizeCallScope = callScope = iterator.next();
                    ArrayList<RfNamedElement> enclosingRandomizeScopes = new ArrayList<RfNamedElement>();
                    while (randomizeCallScope != null) {
                        if (randomizeCallScope instanceof RfFunction) {
                            enclosingRandomizeScopes.add(randomizeCallScope);
                            break;
                        }
                        enclosingRandomizeScopes.add(randomizeCallScope);
                        randomizeCallScope = randomizeCallScope.getEnclosingScope();
                    }
                    if (!(randomizeCallScope instanceof RfFunction)) continue;
                    Collections.reverse(enclosingRandomizeScopes);
                    RfNamedElement commonScope = this.getCommonScope(enclosingStartScopes, enclosingRandomizeScopes);
                    if (commonScope == null) {
                        commonScope = startCallContainer;
                    }
                    for (HidOccurrence occurence : startOccurences) {
                        Predicate<FlowNode> nodePredicate = node -> node instanceof MethodFlowNode && RANDOMIZE.equals(((MethodFlowNode)node).getFunction().getName()) && ((MethodFlowNode)node).getFunction().getParentHid().equals((Object)sequenceHid);
                        Predicate<FlowNode> operatorPredicate = node -> node instanceof OperatorFlowNode && ((OperatorFlowNode)node).containsMethodCall(RANDOMIZE, (IHid)sequenceHid);
                        Predicate<FlowNode> uvmFatalPredicate = node -> node instanceof OperatorFlowNode && ((OperatorFlowNode)node).getOperator().getReparseInfo() != null && "uvm_fatal".equals(((OperatorFlowNode)node).getOperator().getReparseInfo().getLastReparseMacroName());
                        ExecutionFlowGraph executionFlowGraph = this.fOVMProject.getExecutionFlowGraph(commonScope, this, false);
                        executionFlowGraph.setPredicateWithDepth(nodePredicate.or(operatorPredicate.or(uvmFatalPredicate)));
                        boolean nodeOccurres = executionFlowGraph.checkPredicateForEachPossiblePath((DVTPair<Integer, Integer>)new DVTPair((Object)0, (Object)-1), (DVTPair<Integer, Integer>)new DVTPair((Object)occurence.getOffset(), (Object)occurence.getVirtualOffset()));
                        if (!nodeOccurres) continue;
                        if (!validStartHids.containsKey((Object)sequence)) {
                            validStartHids.put(sequence, new HashMap());
                        }
                        if (!((Map)validStartHids.get((Object)sequence)).containsKey(scope)) {
                            ((Map)validStartHids.get((Object)sequence)).put(scope, new HashSet());
                        }
                        ((Set)((Map)validStartHids.get((Object)sequence)).get(scope)).add(occurence);
                    }
                }
            }
        }
        return validStartHids;
    }

    private RfNamedElement getCommonScope(List<RfNamedElement> enclosingStartScopes, List<RfNamedElement> enclosingRandomizeScopes) {
        RfNamedElement commonScope = null;
        int index = 0;
        while (index < enclosingStartScopes.size()) {
            RfNamedElement currentRandomizeScope;
            RfNamedElement currentStartScope;
            if (index >= enclosingRandomizeScopes.size() || !(currentStartScope = enclosingStartScopes.get(index)).equals(currentRandomizeScope = enclosingRandomizeScopes.get(index))) break;
            commonScope = currentStartScope;
            ++index;
        }
        return commonScope;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

