/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.1")
@CheckID(value="XVM.3.7")
@CheckName(value="XVM.3.7")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel._4_STATE, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Banned 4-state variables in sequence items")
@CheckDescription(value="Do not declare 4-state variables in sequence items.\n\nCheck supports pre-waiving.")
public class Check_3_7
extends OVMComplianceCheck {
    public Check_3_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequenceItems.isEmpty()) {
            return;
        }
        for (RfClass seqItem : this.fOVMProject.fSequenceItems.values()) {
            ParserPath parserPath;
            RfDefElement declaration = seqItem.getDeclaration();
            if (declaration == null || (parserPath = declaration.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            String fullName = seqItem.getFullName();
            if (fullName == null) continue;
            seqItem.accept(null, namedElement -> {
                if (!(namedElement instanceof RfField)) {
                    return true;
                }
                RfField field = (RfField)namedElement;
                if (field.isTypeParameter()) {
                    return true;
                }
                RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
                if (fieldType == null) {
                    return true;
                }
                if (LintUtils.isFourStateType(fieldType, false)) {
                    this.addHit(namedElement, "'" + LintUtils.getNamedElementFullName(namedElement) + "' has a 4 state type and is declared inside sequence item '" + fullName + "'!");
                    return true;
                }
                return true;
            });
        }
    }
}

