/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.6")
@CheckID(value="XVM.3.8")
@CheckName(value="XVM.3.8")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.OBJECTION, RuleLabel.VERIFICATION, RuleLabel.PHASE})
@CheckTitle(value="Check starting_phase before calling or raising an objection")
@CheckDescription(value="Always perform the test if (starting_phase != null) or if(get_starting_phase() != null) before calling raise_objection or drop_objection within a sequence.\nPrior to uvm-1.2, starting_phase was a member of the class uvm_sequence_base.\nFrom uvm-1.2 onward, the starting_phase variable is deprecated and instead must be accessed using the get_starting_phase() method\n\nCheck supports pre-waiving.")
public class Check_3_8
extends OVMComplianceCheck {
    private static final String DROP_OBJECTION = "uvm_pkg::uvm_phase.drop_objection";
    private static final String RAISE_OBJECTION = "uvm_pkg::uvm_phase.raise_objection";
    private static final String GET_STARTING_PHASE = "uvm_pkg::uvm_sequence_base.get_starting_phase";
    private static final String STARTING_PHASE = "uvm_pkg::uvm_sequence_base.starting_phase";

    public Check_3_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass sequence = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_sequence", true);
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(sequence);
        this.visitClass(sequence, visited);
    }

    private void visitClass(RfClass baseClass, Set<RfClass> visited) {
        Set<RfClass> children;
        if (baseClass == null) {
            return;
        }
        this.notifyCheckAlive();
        RfFileDef fileDef = baseClass.getFile();
        if (fileDef != null && !this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this) && !this.fOVMProject.isOVMElement(baseClass)) {
            this.handleClass(baseClass);
        }
        if ((children = baseClass.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (RfClass current : children) {
            if (visited.contains(current)) continue;
            visited.add(current);
            this.visitClass(current, visited);
        }
    }

    private void handleClass(RfClass baseClass) {
        baseClass.visitHidObject(null, new IHidVisitor<IHid>(){
            private ParserPath parserPath;
            private RfNamedElement scope;
            private Map<RfNamedElement, Boolean> searchedScopes = new HashMap<RfNamedElement, Boolean>();

            public boolean visit(IHid iHid) {
                if (!(iHid instanceof RfHid)) {
                    return true;
                }
                RfHid hid = (RfHid)iHid;
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                String elementName = ((RfFunction)element).getFullName();
                if (!elementName.equals(Check_3_8.RAISE_OBJECTION) && !elementName.equals(Check_3_8.DROP_OBJECTION)) {
                    return true;
                }
                HidOccurrence occurence = hid.getOccurrence();
                if (occurence == null) {
                    return true;
                }
                if (this.scope instanceof RfActionBlock && this.isValidIf((RfActionBlock)this.scope)) {
                    return true;
                }
                RfNamedElement currentScope = this.scope.getEnclosingScope();
                while (currentScope != null) {
                    if (currentScope instanceof RfActionBlock && this.isValidIf((RfActionBlock)currentScope)) {
                        return true;
                    }
                    currentScope = currentScope.getEnclosingScope();
                }
                Check_3_8.this.addHit(this.parserPath, hid, "Method '" + elementName + "' is called without checking that 'starting_phase' is not null!");
                return true;
            }

            private boolean isValidIf(RfActionBlock actionBlock) {
                if (this.searchedScopes.containsKey(actionBlock)) {
                    return this.searchedScopes.get(actionBlock);
                }
                if (!actionBlock.isIf() && !actionBlock.isElsIf()) {
                    return false;
                }
                boolean result = false;
                IHidObject lhValue = actionBlock.getConditionalBlockExpression();
                if (!(lhValue instanceof RfHidOperator)) {
                    return false;
                }
                RfHidOperator condition = (RfHidOperator)lhValue;
                if (this.isValidComparison(condition)) {
                    result = true;
                }
                this.searchedScopes.put(actionBlock, result);
                return result;
            }

            private boolean isValidComparison(RfHidOperator operator) {
                int operatorType = operator.getOperatorType();
                if (operatorType != 483) {
                    return false;
                }
                ListContainer rhValues = operator.getRHValues();
                if (rhValues == null || rhValues.isEmpty() || operator.getLHValue() == null) {
                    return false;
                }
                return this.areValidOperands(operator.getLHValue(), (IHidObject)rhValues.get(0));
            }

            private boolean areValidOperands(IHidObject leftSide, IHidObject rightSide) {
                boolean foundStartingPhase;
                boolean foundNull = this.isNull(leftSide) || this.isNull(rightSide);
                boolean bl = foundStartingPhase = this.isStartingPhase(leftSide) || this.isStartingPhase(rightSide);
                return foundNull && foundStartingPhase;
            }

            private boolean isStartingPhase(IHidObject iHidObject) {
                RfHidAccessArgs accessArgs;
                Hid parentHid;
                if (iHidObject instanceof RfHidAccessArgs && (parentHid = (accessArgs = (RfHidAccessArgs)iHidObject).getParentHid()) instanceof RfHid) {
                    iHidObject = parentHid;
                }
                if (!(iHidObject instanceof RfHid)) {
                    return false;
                }
                RfHid hid = (RfHid)iHidObject;
                IRfNamedElement element = hid.getElement();
                if (element instanceof RfField) {
                    return ((RfField)element).getFullName().equals(Check_3_8.STARTING_PHASE);
                }
                if (element instanceof RfFunction) {
                    return ((RfFunction)element).getFullName().equals(Check_3_8.GET_STARTING_PHASE);
                }
                return false;
            }

            private boolean isNull(IHidObject iHidObject) {
                if (!(iHidObject instanceof RfHidImplicit)) {
                    return false;
                }
                RfHidImplicit hidImplicit = (RfHidImplicit)iHidObject;
                return hidImplicit.isLiteralNull();
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            public Class<IHid> getType() {
                return IHid.class;
            }
        });
    }
}

