/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

@CheckVersion(value="20.1.39")
@CheckID(value="XVM.3.9")
@CheckName(value="XVM.3.9")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.OVERRIDE, RuleLabel.VERIFICATION})
@CheckTitle(value="do_kill method should be overridden if the kill method of a sequence is called")
@CheckDescription(value="If the kill method of a sequence that can raise an objection is called, then the do_kill method of that sequence should be overridden \nto ensure that the objection is dropped and the phase can end.")
public class Check_3_9
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="If true, child classes with a parent class that overrides do_kill will not be flagged.", name="allowImplementationInParentClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected Boolean pAllowImplementationInParentClasses;
    private static final String RAISE_OBJECTION = "uvm_pkg::uvm_phase.raise_objection";
    private static final String SEQUENCE_ARGUMENT = "obj";
    private Set<RfClass> sequenceKillSet = new HashSet<RfClass>();
    private Set<RfClass> sequenceObjectionSet = new HashSet<RfClass>();

    public Check_3_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass sequence = this.fOVMProject.fOvmSequence;
        if (sequence == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new KillCallVisitor());
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(sequence);
        this.visitClass(sequence, visited, false);
        this.sequenceKillSet.clear();
        this.sequenceObjectionSet.clear();
    }

    private void visitClass(RfClass baseClass, Set<RfClass> visited, boolean hasParentWithObjection) {
        Set<RfClass> children;
        if (baseClass == null) {
            return;
        }
        this.notifyCheckAlive();
        if (this.pAllowImplementationInParentClasses.booleanValue() && !hasParentWithObjection) {
            hasParentWithObjection = this.sequenceObjectionSet.contains(baseClass);
        }
        RfFunction inheritedOrLocalFunction = baseClass.getFunctionWithPrefix("do_kill", 1, this.pAllowImplementationInParentClasses != false ? 2 : 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        RfFunction localFunction = baseClass.getLocalFunction("do_kill");
        if (!this.fOVMProject.isOVMElement(baseClass) && (!this.pAllowImplementationInParentClasses.booleanValue() && localFunction == null || this.pAllowImplementationInParentClasses.booleanValue() && this.fOVMProject.isOVMElement(inheritedOrLocalFunction)) && this.sequenceKillSet.contains(baseClass) && (this.sequenceObjectionSet.contains(baseClass) || this.pAllowImplementationInParentClasses.booleanValue() && hasParentWithObjection)) {
            this.addHit(baseClass, "Kill method of sequence '" + LintUtils.getNamedElementFullName(baseClass) + "' is called and the sequence does not override the do_kill() method!");
        }
        if ((children = baseClass.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (RfClass current : children) {
            if (visited.contains(current)) continue;
            visited.add(current);
            this.visitClass(current, visited, hasParentWithObjection);
        }
    }

    @Override
    public void clean() {
        super.clean();
        if (this.sequenceKillSet != null) {
            this.sequenceKillSet.clear();
        }
        if (this.sequenceObjectionSet != null) {
            this.sequenceObjectionSet.clear();
        }
    }

    private class KillCallVisitor
    implements IHidVisitor<RfHid> {
        private KillCallVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (((RfFunction)element).getName().equals("kill")) {
                this.handleKill(hidObject);
            }
            if (((RfFunction)element).getFullName().equals(Check_3_9.RAISE_OBJECTION)) {
                this.handleRaiseObjection(hidObject);
            }
            return true;
        }

        private void handleRaiseObjection(RfHid hidObject) {
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            for (MethodCall methodCall : methodCalls) {
                Map argumentMap = methodCall.argumentValuesMapRaw;
                if (argumentMap == null || argumentMap.isEmpty()) {
                    return;
                }
                for (Map.Entry entry : argumentMap.entrySet()) {
                    IHidObject iHidObject = (IHidObject)entry.getValue();
                    IRfNamedElement element = (IRfNamedElement)entry.getKey();
                    if (!Check_3_9.SEQUENCE_ARGUMENT.equals(element.getName())) continue;
                    if (!(iHidObject instanceof Hid)) {
                        return;
                    }
                    if (((Hid)iHidObject).getName().equals("this")) {
                        this.handleThis(((Hid)iHidObject).getElement());
                        return;
                    }
                    if (!(((Hid)iHidObject).getElement() instanceof RfField)) continue;
                    this.handleField((RfField)((Hid)iHidObject).getElement());
                    return;
                }
            }
        }

        private void handleField(RfField element) {
            IRfNamedElement associatedElement = element.getAssociatedType();
            if (!(associatedElement instanceof RfClass)) {
                return;
            }
            Check_3_9.this.sequenceObjectionSet.add((RfClass)associatedElement);
        }

        private void handleThis(IRfNamedElement iRfNamedElement) {
            if (iRfNamedElement == null) {
                return;
            }
            if (!(iRfNamedElement instanceof RfThisImplicitVariable)) {
                return;
            }
            IRfNamedElement associatedElement = ((RfThisImplicitVariable)iRfNamedElement).getAssociatedType();
            if (!(associatedElement instanceof RfClass)) {
                return;
            }
            Check_3_9.this.sequenceObjectionSet.add((RfClass)associatedElement);
        }

        private void handleKill(RfHid hidObject) {
            HidAccess parentAccess = hidObject.getParentAccess();
            if (!(parentAccess instanceof RfHidAccess)) {
                return;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (parentHid == null) {
                return;
            }
            IRfNamedElement associatedElement = ((RfField)parentHid.getElement()).getAssociatedType();
            if (!(associatedElement instanceof RfClass)) {
                return;
            }
            Check_3_9.this.sequenceKillSet.add((RfClass)associatedElement);
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

