/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="16.1.31")
@CheckID(value="XVM.4.20")
@CheckName(value="XVM.4.20")
@CheckLabel(labels={RuleLabel.VIRTUAL_INTERFACE, RuleLabel.COMPONENT, RuleLabel.CONFIG_DB, RuleLabel.VERIFICATION})
@CheckTitle(value="Virtual interface shall be assigned to components through uvm_config_db")
@CheckDescription(value="Components' virtual interface variables must be assigned using 'uvm_config_db::get()'\n\nImplementation Notes:\nThis rule checks that 'uvm_config_db::get()' is used in any of the methods declared in the component.\nIt doesnt check that those methods are actually called.\n\nCheck supports pre-waiving.")
public class Check_4_20
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, a local variable may be used to hold the value of the uvm_config_db::get and subsequently assigned to the interface.", name="allowTempVariableAssigning", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowTempVariableAssigning;

    public Check_4_20(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass clazz : this.fOVMProject.getAllComponents().values()) {
            List<RfField> virtualInterfaces;
            RfFileDef fileDef = clazz.getFile();
            if (fileDef != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this) || (virtualInterfaces = XVMLintUtils.getVirtualInterfaceFieldsInClass(clazz, 1)).isEmpty()) continue;
            this.checkIfAssigned(clazz, virtualInterfaces);
        }
    }

    private void checkIfAssigned(RfClass clazz, List<RfField> virtualInterfaces) {
        List<RfFunction> functions = this.fOVMProject.getAllMethodsFromType(clazz, true);
        HashSet<RfField> assignedVirtualInterfaces = new HashSet<RfField>();
        for (RfFunction function : functions) {
            this.notifyCheckAlive();
            ClassVisitor visitor = new ClassVisitor(virtualInterfaces);
            function.visitHidObject(this.fOVMProject.getRfProject(), visitor);
            assignedVirtualInterfaces.addAll(visitor.getAssignedInterfaces());
        }
        if (this.pAllowTempVariableAssigning) {
            AssignmentVisitor visitor = new AssignmentVisitor(virtualInterfaces, assignedVirtualInterfaces);
            clazz.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        }
        for (RfField field : virtualInterfaces) {
            this.addHit(field, "Virtual interface '" + LintUtils.getNamedElementFullName(field) + "' not assigned using 'uvm_config_db::get()'!");
        }
    }

    class AssignmentVisitor
    implements IHidVisitor<IHidOperator> {
        private List<RfField> unassignedVirtualInterfaces;
        private Set<RfField> assignedVirtualInterfaces;

        public AssignmentVisitor(List<RfField> virtualInterfacesWithProblems, Set<RfField> assignedVirtualInterfaces) {
            this.unassignedVirtualInterfaces = virtualInterfacesWithProblems;
            this.assignedVirtualInterfaces = assignedVirtualInterfaces;
        }

        public boolean visit(IHidOperator hidOperator) {
            if (!hidOperator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            IRfNamedElement lhElement = ((RfHid)lhValue).getElement();
            if (!(lhElement instanceof RfField)) {
                return true;
            }
            RfField leftField = (RfField)lhElement;
            if (!this.unassignedVirtualInterfaces.contains(leftField)) {
                return true;
            }
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            IHidObject rightHidObj = (IHidObject)rhValues.get(0);
            if (!(rightHidObj instanceof RfHid)) {
                return true;
            }
            RfHid rightHid = (RfHid)rightHidObj;
            while (rightHid.getParentHid() != null && rightHid.getParentHid() instanceof RfHid) {
                rightHid = (RfHid)rightHid.getParentHid();
            }
            IRfNamedElement rhElement = rightHid.getElement();
            if (!(rhElement instanceof RfField)) {
                return true;
            }
            RfField rightField = (RfField)rhElement;
            if (!this.assignedVirtualInterfaces.contains(rightField)) {
                return true;
            }
            this.unassignedVirtualInterfaces.remove(leftField);
            return true;
        }

        public List<RfField> getUnassignedVirtualInterfaces() {
            return this.unassignedVirtualInterfaces;
        }

        public Class<IHidOperator> getType() {
            return IHidOperator.class;
        }
    }

    private class ClassVisitor
    implements IHidVisitor<IHidObject> {
        List<RfField> virtualInterfaces;
        Set<RfField> checkedVirtualInterfaces = new HashSet<RfField>();

        public ClassVisitor(List<RfField> vi) {
            this.virtualInterfaces = vi;
        }

        public boolean visit(IHidObject hidObject) {
            if (hidObject.getHidKind() != IHidObject.HidKind.HID) {
                return true;
            }
            RfHid rfHid = (RfHid)hidObject;
            if (rfHid.isMethodCall(false)) {
                IRfNamedElement namedElement = rfHid.getElement();
                if (!(namedElement instanceof RfFunction)) {
                    return true;
                }
                if (!this.calledFromUvmConfigDb(rfHid)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                if (methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (!"get".equals(methodCall.getMethodName())) {
                        return true;
                    }
                    if (methodCall.argumentValuesMap == null) continue;
                    for (Map.Entry argumentEntry : methodCall.argumentValuesMap.entrySet()) {
                        IRfNamedElement argumentKey = (IRfNamedElement)argumentEntry.getKey();
                        if (argumentKey == null || !argumentKey.getName().equals("value")) continue;
                        for (IHid hid : (Set)argumentEntry.getValue()) {
                            if (hid.getElement() == null || !(hid.getElement() instanceof RfField)) continue;
                            RfField field = (RfField)hid.getElement();
                            this.virtualInterfaces.remove(field);
                            this.checkedVirtualInterfaces.add(field);
                        }
                    }
                }
            }
            return true;
        }

        private boolean calledFromUvmConfigDb(RfHid rfHid) {
            HidAccess parentAccess = rfHid.getParentAccess();
            if (parentAccess == null) {
                return false;
            }
            IRfNamedElement associatedType = parentAccess.getAssociatedType();
            if (associatedType == null || !(associatedType instanceof RfClass)) {
                return false;
            }
            String name = ((RfClass)associatedType).getFullName();
            return name != null && name.equals("uvm_pkg::uvm_config_db");
        }

        public Set<RfField> getAssignedInterfaces() {
            return this.checkedVirtualInterfaces;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public void setHolder(IHidHolder holder) {
        }

        public void setParserPath(ParserPath parserPath) {
        }
    }
}

