/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractUsedFunctionReturnValueCheck;

@CheckVersion(value="16.1.31")
@CheckID(value="XVM.4.21")
@CheckName(value="XVM.4.21")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.CONFIG_DB, RuleLabel.RETURN, RuleLabel.VERIFICATION})
@CheckTitle(value="Caller shall always check the return value of 'uvm_config_db::get()'")
@CheckDescription(value="Return value of 'uvm_config_db::get()' must be checked.\n\nImplementation Notes:\nThis rule checks only that the return value is assigned to a variable or used in an expression.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="skipCallsCastedToVoid", description="When true, uvm_config_db::get calls casted to void are not checked.", isVisible=true)
public class Check_4_21
extends AbstractUsedFunctionReturnValueCheck {
    public Check_4_21(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.getLibraryKind() == 1) {
            return;
        }
        this.reportUnusedFunctionReturnValues("uvm_pkg::uvm_config_db.get", false);
    }
}

