/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCheckCallsInIfAndAssert;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="20.1.4")
@CheckID(value="XVM.4.21.1")
@CheckName(value="XVM.4.21.1")
@CheckLabel(labels={RuleLabel.CONFIG_DB, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Check uvm_config_db(T)::get calls")
@CheckDescription(value="You must check uvm_config_db(T)::get failures using if or assert.\n\nExamples:\n if(!uvm_config_db #(uvm_object)::get(this, \"*\", \"object_field_name\", 0))\n    `xvm_fatal( get_type_name(), \"uvm_config_db(T)::get failed!\" )\n\n assert(uvm_config_db #(uvm_object)::get(this, \"*\", \"object_field_name\", 0)) else\n    `xvm_fatal( get_type_name(), \"uvm_config_db(T)::get failed!\" )\n\n logic tmp;\n tmp = uvm_config_db #(uvm_object)::get(this, \"*\", \"object_field_name\", 0);\n assert(tmp) else\n    `xvm_fatal( get_type_name(), \"uvm_config_db(T)::get failed!\" )\n\nImplementation Notes:\nWhen using a local variable for checking the randomization status, it is recommended to perform the check immediately after the randomize call.\nThis recommendation is not enforced by the rule.\nWhen allowTempVariableChecking is set, the rule will pass for the following example:\n\n int tmp;\n tmp = uvm_config_db #(uvm_object)::get(this, \"*\", \"object_field_name\", 0);\n tmp = 1;\n assert(tmp) else\n    `xvm_fatal( get_type_name(), \"uvm_config_db(T)::get failed!\")\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="skipCallsCastedToVoid", description="When true, uvm_config_db(T)::get calls casted to void are not checked."), @CheckParameterOverride(name="allowOnlyIfChecking", description="When true, uvm_config_db(T)::get failures must be checked using only if."), @CheckParameterOverride(name="allowTempVariableChecking", description="When true, a local variable may be used to hold the uvm_config_db(T)::get status and subsequently checked."), @CheckParameterOverride(name="checkCondition", description="When true, if/assert conditions containing uvm_config_db(T)::get are also checked(for if: !uvm_config_db(T)::get, for assert:(!)uvm_config_db(T)::get)."), @CheckParameterOverride(name="checkFailureMacros", description="Checked calls in if/assert conditions must also report potential failures using macros from this list."), @CheckParameterOverride(name="analyzeTypeParameterAccess", isVisible=false)})
public class Check_4_21_1
extends AbstractCheckCallsInIfAndAssert {
    public Check_4_21_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.performCallCheck("uvm_pkg::uvm_config_db.get");
    }

    @Override
    protected void addHitForCheck(ParserPath parserPath, HidOperatorOccurrence occurrence, String message, VerissimoAutofixAdditionalInfo verissimoAutofixAdditionalInfo) {
        this.addHit(parserPath, (HidOccurrence)occurrence, message, null);
    }

    @Override
    protected void addHitForCheck(ParserPath parserPath, int line, String message, ReparseInfo reparseInfo, VerissimoAutofixAdditionalInfo verissimoAutofixAdditionalInfo) {
        this.addHit(parserPath, line, message, reparseInfo, null);
    }
}

